/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiEntitiesListener;
import org.chorem.vradi.VradiExtensionsListener;
import org.chorem.vradi.entities.Client;
import org.chorem.vradi.entities.ClientImpl;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.FormImpl;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.GroupForms;
import org.chorem.vradi.entities.GroupFormsImpl;
import org.chorem.vradi.entities.GroupImpl;
import org.chorem.vradi.entities.Infogene;
import org.chorem.vradi.entities.InfogeneImpl;
import org.chorem.vradi.entities.RootThesaurus;
import org.chorem.vradi.entities.RootThesaurusImpl;
import org.chorem.vradi.entities.Sending;
import org.chorem.vradi.entities.SendingImpl;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.entities.SessionImpl;
import org.chorem.vradi.entities.Status;
import org.chorem.vradi.entities.StatusImpl;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.entities.ThesaurusImpl;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.entities.UserImpl;
import org.chorem.vradi.entities.WebHarvestStream;
import org.chorem.vradi.entities.WebHarvestStreamImpl;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.entities.XmlStreamImpl;
import org.chorem.vradi.services.VradiService;
import org.nuiton.util.ListenerSet;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyListener;

public class VradiNotifier
implements WikittyListener {
    private static Log log = LogFactory.getLog(VradiNotifier.class);
    protected Map<BusinessEntitiesEnum, ListenerSet<VradiEntitiesListener<? extends BusinessEntity>>> entitiesListeners = new HashMap<BusinessEntitiesEnum, ListenerSet<VradiEntitiesListener<? extends BusinessEntity>>>();
    protected ListenerSet<VradiExtensionsListener> extentionsListeners = new ListenerSet();

    public VradiNotifier() {
        VradiService.getWikittyService().addWikittyServiceListener((WikittyListener)this, WikittyService.ServiceListenerType.REMOTE);
    }

    public <C extends BusinessEntity> void addVradiListener(Class<C> beanClass, VradiEntitiesListener<C> listener) {
        BusinessEntitiesEnum businessEntitiesEnum = BusinessEntitiesEnum.getValue(beanClass);
        ListenerSet listenerList = this.entitiesListeners.get((Object)businessEntitiesEnum);
        if (listenerList == null) {
            listenerList = new ListenerSet();
            log.info((Object)("Add listener for enties " + (Object)((Object)businessEntitiesEnum) + " class " + beanClass));
            this.entitiesListeners.put(businessEntitiesEnum, (ListenerSet<VradiEntitiesListener<? extends BusinessEntity>>)listenerList);
        }
        listenerList.add(listener);
    }

    public void addVradiListener(VradiExtensionsListener listener) {
        this.extentionsListeners.add((Object)listener);
    }

    public <C extends BusinessEntity> void removeVradiEntitiesListener(Class<C> beanClass, VradiEntitiesListener<C> listener) {
        BusinessEntitiesEnum businessEntitiesEnum = BusinessEntitiesEnum.getValue(beanClass);
        ListenerSet<VradiEntitiesListener<? extends BusinessEntity>> listenerList = this.entitiesListeners.get((Object)businessEntitiesEnum);
        if (listenerList == null) {
            return;
        }
        listenerList.remove(listener);
    }

    public void removeVradiExtensionsListener(VradiExtensionsListener listener) {
        this.extentionsListeners.remove((Object)listener);
    }

    protected Map<BusinessEntitiesEnum, Set<? extends BusinessEntity>> extractEntities(WikittyEvent event) {
        HashMap<BusinessEntitiesEnum, Set<? extends BusinessEntity>> toNotify = new HashMap<BusinessEntitiesEnum, Set<? extends BusinessEntity>>();
        Map wikittiesMap = event.getWikitties();
        if (wikittiesMap != null) {
            for (Wikitty w : wikittiesMap.values()) {
                BusinessEntitiesEnum businessEntitiesEnum = BusinessEntitiesEnum.getValue(w);
                if (businessEntitiesEnum == null) continue;
                businessEntitiesEnum.addToMap(businessEntitiesEnum.getBeanClass(), toNotify, w);
            }
        }
        return toNotify;
    }

    protected Set<WikittyExtension> extractExtensions(Map<String, WikittyExtension> extensionsMap) {
        HashSet<WikittyExtension> extensions = new HashSet<WikittyExtension>();
        if (extensionsMap != null) {
            for (WikittyExtension extension : extensionsMap.values()) {
                if (!extension.getFieldNames().contains("Form")) continue;
                extensions.add(extension);
            }
        }
        return extensions;
    }

    protected Set<String> extractDeletedIds(WikittyEvent event) {
        Map removeDate = event.getRemoveDate();
        if (removeDate != null) {
            return removeDate.keySet();
        }
        return Collections.emptySet();
    }

    public void notifyAllAddEntities(Map<BusinessEntitiesEnum, ListenerSet<VradiEntitiesListener<? extends BusinessEntity>>> listeners, Map<BusinessEntitiesEnum, Set<? extends BusinessEntity>> toNotify) {
        for (BusinessEntitiesEnum businessEntitiesEnum : toNotify.keySet()) {
            Set<? extends BusinessEntity> entitiesToNotify = toNotify.get((Object)businessEntitiesEnum);
            ListenerSet<VradiEntitiesListener<? extends BusinessEntity>> listernersToNotify = listeners.get((Object)businessEntitiesEnum);
            this.notifyAllAddEntities(businessEntitiesEnum.getBeanClass(), listernersToNotify, entitiesToNotify);
        }
    }

    protected <C extends BusinessEntity> void notifyAllAddEntities(Class<C> beanClass, ListenerSet<VradiEntitiesListener<? extends BusinessEntity>> listernersToNotify, Set<? extends BusinessEntity> entitiesToNotify) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[VradiNotifier] notifyAllAddEntities of type : " + beanClass.getName()));
        }
        if (listernersToNotify != null) {
            for (VradiEntitiesListener listener : listernersToNotify) {
                this.notifyAddEntities(listener, entitiesToNotify);
            }
        }
    }

    protected <C extends BusinessEntity> void notifyAddEntities(VradiEntitiesListener<C> listener, Set<C> entities) {
        listener.entitiesAdded(entities);
    }

    public void notifyAllRemoveEntities(Map<BusinessEntitiesEnum, ListenerSet<VradiEntitiesListener<? extends BusinessEntity>>> listeners, Set<String> toNotify) {
        for (ListenerSet<VradiEntitiesListener<? extends BusinessEntity>> listenerSet : listeners.values()) {
            for (VradiEntitiesListener listener : listenerSet) {
                this.notifyRemoveEntities(listener, toNotify);
            }
        }
    }

    protected <C extends BusinessEntity> void notifyRemoveEntities(VradiEntitiesListener<C> listener, Set<String> removedIds) {
        listener.entitiesRemoved(removedIds);
    }

    public void notifyAllAddExtensions(ListenerSet<VradiExtensionsListener> listernersToNotify, Set<WikittyExtension> extensions) {
        if (listernersToNotify != null) {
            for (VradiExtensionsListener listener : listernersToNotify) {
                this.notifyAddExtensions(listener, extensions);
            }
        }
    }

    protected void notifyAddExtensions(VradiExtensionsListener listener, Set<WikittyExtension> extensions) {
        listener.extensionsAdded(extensions);
    }

    public void notifyAllRemoveExtensions(ListenerSet<VradiExtensionsListener> listernersToNotify, Set<String> extensionsIds) {
        if (listernersToNotify != null) {
            for (VradiExtensionsListener listener : listernersToNotify) {
                this.notifyRemoveExtensions(listener, extensionsIds);
            }
        }
    }

    protected void notifyRemoveExtensions(VradiExtensionsListener listener, Set<String> extensionsIds) {
        listener.extensionsRemoved(extensionsIds);
    }

    public void putWikitty(WikittyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"[VradiNotifier] Put wikitty");
        }
        Map<BusinessEntitiesEnum, Set<? extends BusinessEntity>> toNotify = this.extractEntities(event);
        this.notifyAllAddEntities(this.entitiesListeners, toNotify);
    }

    public void removeWikitty(WikittyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"[VradiNotifier] Remove wikitty");
        }
        Set<String> toNotify = this.extractDeletedIds(event);
        this.notifyAllRemoveEntities(this.entitiesListeners, toNotify);
    }

    public void clearWikitty(WikittyEvent event) {
    }

    public void putExtension(WikittyEvent event) {
        Set<WikittyExtension> extensions = this.extractExtensions(event.getExtensions());
        this.notifyAllAddExtensions(this.extentionsListeners, extensions);
    }

    public void removeExtension(WikittyEvent event) {
        Set extensionsIds = event.getDeletedExtensions();
        this.notifyAllRemoveExtensions(this.extentionsListeners, extensionsIds);
    }

    public void clearExtension(WikittyEvent event) {
    }

    protected static enum BusinessEntitiesEnum {
        CLIENT(Client.class, ClientImpl.class, "Client"),
        GROUP(Group.class, GroupImpl.class, "Group"),
        USER(User.class, UserImpl.class, "User"),
        STATUS(Status.class, StatusImpl.class, "Status"),
        WEB_HARVEST_STREAM(WebHarvestStream.class, WebHarvestStreamImpl.class, "WebHarvestStream"),
        XML_STREAM(XmlStream.class, XmlStreamImpl.class, "XmlStream"),
        FORM(Form.class, FormImpl.class, "Form"),
        INFOGENE(Infogene.class, InfogeneImpl.class, "Infogene"),
        THESAURUS(Thesaurus.class, ThesaurusImpl.class, "Thesaurus"),
        ROOT_THESAURUS(RootThesaurus.class, RootThesaurusImpl.class, "RootThesaurus"),
        SESSION(Session.class, SessionImpl.class, "Session"),
        SENDING(Sending.class, SendingImpl.class, "Sending"),
        GROUP_FORMS(GroupForms.class, GroupFormsImpl.class, "GroupForms");

        private Class<? extends BusinessEntity> beanClass;
        private Class<? extends BusinessEntityImpl> beanImplClass;
        private String ext;

        private BusinessEntitiesEnum(Class<? extends BusinessEntity> beanClass, Class<? extends BusinessEntityImpl> beanImplClass, String ext) {
            this.ext = ext;
            this.beanClass = beanClass;
            this.beanImplClass = beanImplClass;
        }

        public Class<? extends BusinessEntity> getBeanClass() {
            return this.beanClass;
        }

        private Class<? extends BusinessEntityImpl> getBeanImplClass() {
            return this.beanImplClass;
        }

        public String getExt() {
            return this.ext;
        }

        public static BusinessEntitiesEnum getValue(Class<? extends BusinessEntity> beanClass) {
            for (BusinessEntitiesEnum constant : BusinessEntitiesEnum.values()) {
                if (!beanClass.equals(constant.getBeanClass())) continue;
                return constant;
            }
            return null;
        }

        public static BusinessEntitiesEnum getValue(Wikitty wikitty) {
            for (BusinessEntitiesEnum constant : BusinessEntitiesEnum.values()) {
                if (!wikitty.hasExtension(constant.getExt())) continue;
                return constant;
            }
            return null;
        }

        public <C extends BusinessEntity> C getBusinessEntity(Class<C> classToConvert, Wikitty wikitty) {
            Class<? extends BusinessEntityImpl> beanClass = this.getBeanImplClass();
            BusinessEntity result = null;
            try {
                Constructor<? extends BusinessEntityImpl> cons = beanClass.getConstructor(Wikitty.class);
                result = (BusinessEntity)cons.newInstance(wikitty);
            }
            catch (NoSuchMethodException eee) {
                log.error((Object)("Failed to find constructor of '" + beanClass + "' : "), (Throwable)eee);
            }
            catch (InstantiationException eee) {
                log.error((Object)("Failed to instanciate '" + beanClass + "' : "), (Throwable)eee);
            }
            catch (IllegalAccessException eee) {
                log.error((Object)eee);
            }
            catch (InvocationTargetException eee) {
                log.error((Object)eee);
            }
            return (C)result;
        }

        public <C extends BusinessEntity> void addToMap(Class<C> classToConvert, Map<BusinessEntitiesEnum, Set<? extends BusinessEntity>> mapToAdd, Wikitty wikitty) {
            Set<? extends BusinessEntity> listToAdd = mapToAdd.get((Object)this);
            if (listToAdd == null) {
                listToAdd = new HashSet<BusinessEntity>();
                mapToAdd.put(this, listToAdd);
            }
            listToAdd.add((BusinessEntity)this.getBusinessEntity(classToConvert, wikitty));
        }
    }
}

