/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: ReceiveMailTasks.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-services/src/main/java/org/chorem/vradi/services/tasks/ReceiveMailTasks.java $
 * %%
 * Copyright (C) 2010 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package org.chorem.vradi.services.tasks;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.managers.MailingManager;

import java.util.TimerTask;

/**
 * This task import xml stream at stream specified time.
 *
 * @author chatellier
 * @version $Revision: 21 $
 *          <p/>
 *          Last update : $Date: 2011-05-09 18:43:58 +0200 (lun., 09 mai 2011) $
 *          By : $Author: sletellier $
 */
public class ReceiveMailTasks extends TimerTask {

    private static final Log log = LogFactory.getLog(ReceiveMailTasks.class);

    protected MailingManager mailingManager;

    public ReceiveMailTasks(MailingManager mailingManager) {
        this.mailingManager = mailingManager;
    }

    /*
     * @see java.util.TimerTask#run()
     */
    @Override
    public void run() {
        try {
            if (log.isInfoEnabled()) {
                log.info("Checking for notification and error emails...");
            }
            mailingManager.receiveMails();

        } catch (VradiException eee) {
            if (log.isErrorEnabled()) {
                log.error("Mailing task can't run", eee);
            }
        }
    }
}
