/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: UnsupportedQueryException.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-services/src/main/java/org/chorem/vradi/services/search/UnsupportedQueryException.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.services.search;

import org.apache.lucene.search.Query;

import static org.nuiton.i18n.I18n._;

/**
 * <code>UnsupportedQueryException</code> indicates that a <code>Query</code>
 * is not supported by the <code>LuceneQueryParser</code>.
 *
 * @author $Author: sletellier $
 * @version $Revision: 21 $ $Date: 2011-05-09 18:43:58 +0200 (lun., 09 mai 2011) $
 * @since 0.0.4
 */
public class UnsupportedQueryException extends Exception {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** Query that throw the exception. */
    protected String query = null;

    public UnsupportedQueryException(String query, Throwable cause) {
        super(_("Unsupported query: %s", query), cause);
        this.query = query;
    }

    public UnsupportedQueryException(Query query) {
        super("unsupported query: " + query.toString());
    }

    public String getQuery() {
        return query;
    }
}
