/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: VradiServiceConfiguration.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-services/src/main/java/org/chorem/vradi/VradiServiceConfiguration.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package org.chorem.vradi;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.wikitty.WikittyConfigOption;

import java.io.File;
import java.util.Locale;
import java.util.Properties;

import static org.nuiton.i18n.I18n._;

/**
 * Configuration.
 *
 * @author schorlet
 * @version $Revision: 21 $ $Date: 2011-05-09 18:43:58 +0200 (lun., 09 mai 2011) $
 * @since 26 mars 2010 21:18:08
 */
public class VradiServiceConfiguration {

    /** log. */
    private static final Log log = LogFactory.getLog(VradiServiceConfiguration.class);

    /** After init step. */
    public static final int STEP_AFTER_INIT = 0;

    /** Singleton instance. */
    protected static ApplicationConfig config = null;

    public static final String DATA_DEFAULT_DIR = "${user.home}" + File.separator + ".vradi" +
                                                  File.separator + "vradi-${application.version}";

    public static final String ATTACHEMENTS_DEFAULT_DIR_NAME = "attachments";

    public static final String SESSION_ATTACHEMENTS_DEFAULT_DIR_NAME = "sessionAttachments";

    public static final String EMBEDDED_DEFAULT_DIR_NAME = "embeddedFiles";

    public static final String QUERY_HISTORY_DEFAULT_DIR_NAME = "queryHistory";

    public static final String TEMPLATE_DEFAULT_DIR_NAME = "templates";

    public static final String PDF_DEFAULT_DIR_NAME = "pdf";

    public static final String TEMP_DEFAULT_DIR_NAME = "temp";

    public static final String EXPORT_CSV_DEFAULT_DIR_NAME = "exportCSV";

    public static final String IMPORT_CSV_DEFAULT_DIR_NAME = "importCSV";

    public static final String WEB_HARVERT_SCRIPT_DEFAULT_DIR_NAME = "WebHarvestScript";

    public static final String WEB_HARVERT_SCRIPT_PREVIEW_DEFAULT_DIR_NAME = "WebHarvestPreview";

    private VradiServiceConfiguration() {
    }

    public static ApplicationConfig getConfig(String ... args) {
        return getConfig(null, args);
    }

    public static ApplicationConfig getConfig(Properties defaults, String ... args) {

        if (config == null) {
            config = new ApplicationConfig(null, null, defaults, VradiServiceOption.CONFIG_FILE.getDefaultValue());

            // Load wikitty options
            config.loadDefaultOptions(WikittyConfigOption.class);

            // Load vradi service option
            config.loadDefaultOptions(VradiServiceOption.class);

            // Load vradi service action
            config.loadActions(VradiServiceActionDef.class);
            try {
                // Parse args
                config.parse(args);
            } catch (ArgumentsParserException eee) {
                if (log.isErrorEnabled()) {
                    log.error("Can't load vradi configuration", eee);
                }
            }
        }
        return config;
    }

    /**
     * Set {@code solr} and {@code jms} system configuration.
     * <p/>
     * This is the "only" way to configure embedded solr.
     */
//    protected void setSystemDefaultProps() {
//        String[] datadirs = new String[]{"solr.data.dir", "wikitty.searchengine.solr.directory.data", "vradi.objectStore.dir"};
//
//        for (String datadir : datadirs) {
//            String value = System.getProperty(datadir, null);
//            if (value == null) {
//                value = getOption(datadir);
//                if (log.isInfoEnabled()) {
//                    log.info("Setting system property " + datadir + " : " + value);
//                }
//                if (value != null) {
//                    System.setProperty(datadir, value);
//                    env.put(datadir, value);
//                }
//            }
//        }
//    }

//    public static synchronized VradiServiceConfiguration getInstance(String... args) {
//        if (instance == null) {
//            try {
//                instance = new VradiServiceConfiguration();
//                instance.parse(args);
//                instance.setSystemDefaultProps();
//            } catch (Exception ex) {
//                if (log.isErrorEnabled()) {
//                    log.error("Can't intitialize configuration", ex);
//                }
//                throw new UnhandledException(ex);
//            }
//        }
//        return instance;
//    }

    /** Vradi option definition. */
    public static enum VradiServiceOption implements ApplicationConfig.OptionDef {

        CONFIG_FILE(
                ApplicationConfig.CONFIG_FILE_NAME,
                _("vradi.service.config.configFileName.description"),
                "vradi-services.properties",
                String.class, true, true),

        APPLICATION_VERSION(
                "application.version",
                _("vradi.service.config.application.version.description"),
                null, String.class, false, false),

        SERVICE_VERSION(
                "vradi.service.version",
                _("vradi.service.config.version.description"),
                null, String.class, false, false),

        DATA_DIR(
                "vradi.data.dir",
                _("vradi.service.config.data.dir.description"),
                DATA_DEFAULT_DIR,
                String.class, false, false),

        LOCALE(
                "vradi.service.locale",
                _("vradi.service.config.ui.locale.description"),
                Locale.FRANCE.toString(), Locale.class, false, false),

        MAIL_ADMIN(
                "vradi.mail.admin",
                _("vradi.service.config.mail.admin.description"),
                null, String.class, false, false),

        OOO_DIR(
                "oOo.exec.folder",
                _("vradi.service.config.oOo.exec.folder.description"),
                "${user.home}/.vradi/vradi-${application.version}",
                String.class, false, false),

        MAIL_DEBUG(
                "vradi.mail.debug",
                _("vradi.service.config.mail.debug.description"),
                Boolean.FALSE.toString(), Boolean.class, false, false),

        SMTP_HOST(
                "vradi.smtp.host",
                _("vradi.service.config.smtp.host.description"),
                null, String.class, false, false),

        SMTP_PORT(
                "vradi.smtp.port",
                _("vradi.service.config.smtp.port.description"),
                null, Integer.class, false, false),

        IMAP_HOST(
                "vradi.imap.host",
                _("vradi.service.config.imap.host.description"),
                null, Integer.class, false, false),

        IMAP_PORT(
                "vradi.imap.port",
                _("vradi.service.config.imap.port.description"),
                null, Integer.class, false, false),

        MAIL_USER(
                "vradi.mail.user",
                _("vradi.service.config.mail.user.description"),
                null, String.class, false, false),

        MAIL_FROM(
                "vradi.mail.from",
                _("vradi.service.config.mail.from.description"),
                null, String.class, false, false),

        MAIL_FROM_NAME(
                "vradi.mail.fromname",
                _("vradi.service.config.mail.fromname.description"),
                null, String.class, false, false),

        MAIL_PASSWORD(
                "vradi.mail.password",
                _("vradi.service.config.mail.password.description"),
                null, String.class, false, false),

        MAIL_OFFER_SUBJECT(
                "vradi.mail.offer.subject",
                _("vradi.service.config.mail.offer.subject.description"),
                null, String.class, false, false),

        SESSION_DEFAULT_PARAGRAPH(
                "vradi.session.defaultParagraph",
                _("vradi.service.config.session.defaultParagraph.description"),
                null, String.class, false, false),

        SKIP_MIGRATION(
                "vradi.migration.skip",
                _("vradi.service.config.migration.skip.description"),
                Boolean.FALSE.toString(), Boolean.class, false, false),

        ATTACHEMENTS_DIR(
                "vradi.attachments.dir",
                _("vradi.service.config.migration.skip.description"),
                getDefaultDir(ATTACHEMENTS_DEFAULT_DIR_NAME),
                String.class, false, false),

        SESSION_ATTACHEMENTS_DIR(
                "vradi.session.attachments.dir",
                _("vradi.service.config.migration.skip.description"),
                getDefaultDir(SESSION_ATTACHEMENTS_DEFAULT_DIR_NAME),
                String.class, false, false),

        EMBEDDED_DIR(
                "vradi.embeddedFiles.dir",
                _("vradi.service.config.migration.skip.description"),
                getDefaultDir(EMBEDDED_DEFAULT_DIR_NAME),
                String.class, false, false),

        QUERY_HISTORY_DIR(
                "vradi.queryHistory.dir",
                _("vradi.service.config.migration.skip.description"),
                getDefaultDir(QUERY_HISTORY_DEFAULT_DIR_NAME),
                String.class, false, false),

        TEMPLATE_DIR(
                "vradi.templates.dir",
                _("vradi.service.config.migration.skip.description"),
                getDefaultDir(TEMPLATE_DEFAULT_DIR_NAME),
                String.class, false, false),

        PDF_DIR(
                "vradi.pdf.dir",
                _("vradi.service.config.migration.skip.description"),
                getDefaultDir(PDF_DEFAULT_DIR_NAME),
                String.class, false, false),

        TEMP_DIR(
                "vradi.temp.dir",
                _("vradi.service.config.migration.skip.description"),
                getDefaultDir(TEMPLATE_DEFAULT_DIR_NAME),
                String.class, false, false),

        EXPORT_CSV_DIR(
                "vradi.exportCSV.dir",
                _("vradi.service.config.migration.skip.description"),
                getDefaultDir(EXPORT_CSV_DEFAULT_DIR_NAME),
                String.class, false, false),

        IMPORT_CSV_DIR(
                "vradi.importCSV.dir",
                _("vradi.service.config.migration.skip.description"),
                getDefaultDir(IMPORT_CSV_DEFAULT_DIR_NAME),
                String.class, false, false),

        WEB_HARVERT_SCRIPT_DIR(
                "vradi.WebHarvestScript.dir",
                _("vradi.service.config.migration.skip.description"),
                getDefaultDir(WEB_HARVERT_SCRIPT_DEFAULT_DIR_NAME),
                String.class, false, false),

        WEB_HARVERT_SCRIPT_PREVIEW_DIR(
                "vradi.WebHarvestPreview.dir",
                _("vradi.service.config.migration.skip.description"),
                getDefaultDir(WEB_HARVERT_SCRIPT_PREVIEW_DEFAULT_DIR_NAME),
                String.class, false, false),

        AUTO_SEND_HOUR(
                "vradi.autoSend.hour",
                _("vradi.autoSend.hour.description"),
                null,
                String.class, false, false);

        public String key;

        public String description;

        public String defaultValue;

        public Class<?> type;

        public boolean isTransient;

        public boolean isFinal;

        private VradiServiceOption(String key, String description, String defaultValue,
                                   Class<?> type, boolean isTransient, boolean isFinal) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this.isFinal = isFinal;
            this.isTransient = isTransient;
        }

        @Override
        public String getKey() {
            return key;
        }

        @Override
        public Class<?> getType() {
            return type;
        }

        @Override
        public String getDescription() {
            return description;
        }

        @Override
        public String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public boolean isTransient() {
            return isTransient;
        }

        @Override
        public boolean isFinal() {
            return isFinal;
        }

        @Override
        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public void setTransient(boolean isTransient) {
            this.isTransient = isTransient;
        }

        @Override
        public void setFinal(boolean isFinal) {
            this.isFinal = isFinal;
        }

        private static String getDefaultDir(String dirName) {
            String defaultDir = "${" + DATA_DIR.key + "}" + File.separator + dirName;
            return defaultDir;
        }
    }

    /**
     * Actions can be called in command line
     *
     * @author sletellier <letellier@codelutin.com>
     */
    public enum VradiServiceActionDef implements ApplicationConfig.ActionDef {

        HELP(
                VradiServiceAction.class.getName() + "#help",
                _("vradi.service.config.help.description"),
                "-h", "--help"),

        REINDEX_SOLR(
                VradiServiceAction.class.getName() + "#reIndexSolr",
                _("vradi.service.config.reIndexSolr.description"),
                "--reIndexSolr"),

        DELETE_OBSELETE_THESAURUS(
                VradiServiceAction.class.getName() + "#deleteObseleteThesaurus",
                _("vradi.service.config.deleteObseleteThesaurus.description"),
                "--deleteObseleteThesaurus"),

        REINIT_STATUS(
                VradiServiceAction.class.getName() + "#reinitStatus",
                _("vradi.service.config.reinitStatus.description"),
                "--reinitStatus"),

        FORCE_ALL_OLD_USER_ENABLE(
                VradiServiceAction.class.getName() + "#forceAllOldUserEnable",
                _("vradi.service.config.forceAllOldUserEnable.description"),
                "--forceAllOldUserEnable"),

        DELETE_OBSELETE_USERS(
                VradiServiceAction.class.getName() + "#deleteObseleteUsers",
                _("vradi.service.config.deleteObseleteUsers.description"),
                "--deleteObseleteUsers"),

        IMPORT_FILES(
                VradiServiceAction.class.getName() + "#importFiles",
                _("vradi.service.config.importFiles.description"),
                "--importFiles"),

        EXPORT_CLIENTS(
                VradiServiceAction.class.getName() + "#exportClients",
                _("vradi.service.config.exportClients.description"),
                "--exportClients"),

        EXPORT_THESAURUS(
                VradiServiceAction.class.getName() + "#exportThesaurus",
                _("vradi.service.config.exportThesaurus.description"),
                "--exportThesaurus");

        protected String action;

        protected String description;

        protected String[] aliases;

        private VradiServiceActionDef(String action, String description, String... aliases) {
            this.action = action;
            this.description = description;
            this.aliases = aliases;
        }

        @Override
        public String getAction() {
            return action;
        }

        public String getDescription() {
            return action;
        }

        @Override
        public String[] getAliases() {
            return aliases;
        }
    }
}
