/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.TrimFilter;
import org.apache.solr.common.SolrException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrimFilterFactory
extends BaseTokenFilterFactory {
    protected boolean updateOffsets = false;

    @Override
    public void init(Map<String, String> args) {
        super.init((Map)args);
        String v = args.get("updateOffsets");
        if (v != null) {
            try {
                this.updateOffsets = Boolean.valueOf(v);
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error reading updateOffsets value.  Must be true or false.", (Throwable)ex);
            }
        }
    }

    public TrimFilter create(TokenStream input) {
        return new TrimFilter(input, this.updateOffsets);
    }
}

