/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.util.MultiMap;

public class HashSessionIdManager
extends AbstractSessionIdManager {
    MultiMap<String> _sessions;

    public HashSessionIdManager() {
    }

    public HashSessionIdManager(Random random) {
        super(random);
    }

    public String getNodeId(String clusterId, HttpServletRequest request) {
        String worker;
        String string = worker = request == null ? null : (String)request.getAttribute("org.eclipse.http.ajp.JVMRoute");
        if (worker != null) {
            return clusterId + '.' + worker;
        }
        if (this._workerName != null) {
            return clusterId + '.' + this._workerName;
        }
        return clusterId;
    }

    public String getClusterId(String nodeId) {
        int dot = nodeId.lastIndexOf(46);
        return dot > 0 ? nodeId.substring(0, dot) : nodeId;
    }

    protected void doStart() throws Exception {
        this._sessions = new MultiMap(true);
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this._sessions != null) {
            this._sessions.clear();
        }
        this._sessions = null;
        super.doStop();
    }

    public boolean idInUse(String id) {
        return this._sessions.containsKey(id);
    }

    public void addSession(HttpSession session) {
        this._sessions.add(this.getClusterId(session.getId()), session);
    }

    public void removeSession(HttpSession session) {
        this._sessions.removeValue(this.getClusterId(session.getId()), session);
    }

    public void invalidateAll(String id) {
        while (this._sessions.containsKey(id)) {
            AbstractSessionManager.Session session = (AbstractSessionManager.Session)this._sessions.getValue(id, 0);
            if (session.isValid()) {
                session.invalidate();
            }
            this._sessions.removeValue(id, session);
        }
    }
}

