/*
 * #%L
 * Pollen :: Vote Counting
 * $Id: PollChoiceDTO.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-votecounting/src/main/java/org/chorem/pollen/votecounting/dto/PollChoiceDTO.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting.dto;

/**
 * Classe DTO représentant un choix de vote.
 *
 * @version $Id: PollChoiceDTO.java 3423 2012-06-05 16:50:22Z tchemit $
 */
public class PollChoiceDTO {
    private String idChoice;

    private String name;

    private String description;

    private boolean hidden;

    public PollChoiceDTO(String idChoice) {
        this.idChoice = idChoice;
        this.name = "";
        this.description = "";
        this.hidden = false;
    }

    public PollChoiceDTO(int idChoice) {
        this.idChoice = String.valueOf(idChoice);
        this.name = "";
        this.description = "";
        this.hidden = false;
    }

    public String getIdChoice() {
        return idChoice;
    }

    public void setIdChoice(String idChoice) {
        this.idChoice = idChoice;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isHidden() {
        return hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}
