/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Preconditions;
import org.apache.commons.io.IOUtils;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.ui.actions.PollenActionSupport;

import java.io.InputStream;

/**
 * Obtain the feed of a given poll.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetPollFeed extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    protected String pollId;

    protected long contentLength;

    protected transient InputStream inputStream;

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public long getContentLength() {
        return contentLength;
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    @Override
    public String execute() throws Exception {

        Preconditions.checkNotNull(pollId);

        Poll poll = getPollService().getExistingPollByPollId(pollId);

        String content = getPollFeedService().getFeed(poll);

        contentLength = content.length();

        inputStream = IOUtils.toInputStream(content);

        return SUCCESS;
    }
}
