/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: DeleteChoice.java 3611 2012-08-13 14:11:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/vote/DeleteChoice.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll.vote;

import com.google.common.base.Preconditions;
import org.chorem.pollen.ui.actions.PollUriAware;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.chorem.pollen.ui.actions.PollenUserSecurityAware;

/**
 * To delete a poll choice
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class DeleteChoice extends PollenActionSupport implements PollenUserSecurityAware, PollUriAware {

    private static final long serialVersionUID = 1L;

    protected String choiceId;

    public void setChoiceId(String choiceId) {
        this.choiceId = choiceId;
    }

    @Override
    public String execute() throws Exception {

        Preconditions.checkNotNull(choiceId);

        getPollService().deleteChoice(getPollUri().getPollId(), choiceId);

        addFlashMessage(_("pollen.information.choice.deleted"));
        return SUCCESS;
    }

}
