/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: ImportPersonListToVotingList.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/ImportPersonListToVotingList.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Function;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.services.PollenServiceFunctions;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.ui.actions.PollenActionSupport;

/**
 * Load in session a personToList to import into a votingList.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class ImportPersonListToVotingList extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    /** Type of the voting list. */
    protected String votingListType;

    /** Number of person to display. */
    protected int votingListNumber;

    /** The voting list ot display. */
    protected VotingList votingList;

    protected int startNumber;

    protected String personListId;

    public int getVotingListNumber() {
        return votingListNumber;
    }

    public int getStartNumber() {
        return startNumber;
    }

    public String getVotingListType() {
        return votingListType;
    }

    public VotingList getVotingList() {
        return votingList;
    }

    public void setVotingListNumber(int votingListNumber) {
        this.votingListNumber = votingListNumber;
    }

    public void setVotingListType(String votingListType) {
        this.votingListType = votingListType;
    }

    public void setStartNumber(int startNumber) {
        this.startNumber = startNumber;
    }

    public void setPersonListId(String personListId) {
        this.personListId = personListId;
    }

    @Override
    public String execute() throws Exception {

        PersonList favoriteList =
                getFavoriteService().getFavoriteList(getPollenUserAccount(), personListId);

        Function<PersonToList, PersonToList> persontoListCreator =
                PollenServiceFunctions.newPersonToListCreator();

        Function<VotingList, VotingList> votingListCreator =
                PollenServiceFunctions.newVotingListCreator(persontoListCreator);

        votingList = votingListCreator.apply(null);

        PollService pollService = getPollService();

        for (PollAccount pollAccount : favoriteList.getPollAccount()) {

            PersonToList p = pollService.getNewPersonToList(pollAccount);
            votingList.addPollAccountPersonToList(p);
        }

        return SUCCESS;
    }
}
