/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: DeleteComment.java 3516 2012-06-18 16:19:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/DeleteComment.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import org.chorem.pollen.business.persistence.Poll;

/**
 * To delete a poll comment.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class DeleteComment extends AbstractVoteAction {

    private static final long serialVersionUID = 1L;

    /**
     * Id of the comment to delete.
     *
     * @since 1.3
     */
    protected String commentId;

    /**
     * Reason for deleting this comment (if any).
     *
     * @since 1.4
     */
    protected String reason;

    public void setCommentId(String commentId) {
        this.commentId = commentId;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public boolean isModerate() {
        return false;
    }

    @InputConfig(methodName = PREPARE_VOTE_PAGE)
    @Override
    public String execute() throws Exception {

        Preconditions.checkNotNull(getPollId());
        Preconditions.checkNotNull(commentId);

        Poll poll = getPollService().getExistingPollByPollId(getPollId());

        getPollCommentService().deleteComment(poll, commentId, reason);

        addFlashMessage(_("pollen.information.comment.deleted"));
        return SUCCESS;
    }
}
