/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.persistence.entity.VoteToChoice;
import org.chorem.pollen.persistence.entity.VoterList;
import org.chorem.pollen.persistence.entity.VoterListMember;
import org.chorem.pollen.services.bean.ListVoteCountingResultBean;
import org.chorem.pollen.services.bean.VoteBean;
import org.chorem.pollen.services.bean.VoteCountingResultBean;
import org.chorem.pollen.services.service.ErrorMap;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.services.service.Polls;
import org.chorem.pollen.services.service.security.PollenPermissions;
import org.chorem.pollen.votecounting.api.VoteCounting;
import org.chorem.pollen.votecounting.api.VoteCountingFactory;
import org.chorem.pollen.votecounting.api.VoteCountingStrategy;
import org.chorem.pollen.votecounting.api.VoteCountings;
import org.chorem.pollen.votecounting.api.model.ListOfVoter;
import org.chorem.pollen.votecounting.api.model.ListVoteCountingResult;
import org.chorem.pollen.votecounting.api.model.SimpleVoter;
import org.chorem.pollen.votecounting.api.model.VoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.VoteCountingResult;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;

public class VoteCountingService
extends PollenServiceSupport {
    public VoteCountingResultBean getMainResult(String questionId) {
        VoteCountingResultBean mainResult;
        this.checkIsConnectedRequired();
        Preconditions.checkNotNull((Object)questionId);
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.readResult(question));
        if (Polls.isPollRestricted(question.getPoll())) {
            ListVoteCountingResultBean groupResult = this.getGroupResult(questionId);
            mainResult = groupResult.getMainResult();
        } else {
            mainResult = this.getSimpleResult(questionId);
        }
        return mainResult;
    }

    public VoteCountingConfig newConfig(VoteCountings voteCountingType) {
        VoteCountingFactory voteCountingFactory = this.serviceContext.getVoteCountingFactory();
        VoteCounting voteCounting = voteCountingFactory.getVoteCounting(voteCountingType);
        return voteCounting.createConfig();
    }

    protected String configToJson(VoteCountingConfig config) {
        Gson gson = new GsonBuilder().create();
        return gson.toJson((Object)config);
    }

    public VoteCountingConfig getVoteCountingConfig(Question question) {
        VoteCounting voteCounting = this.getVoteCounting(question);
        return voteCounting.newStrategy().parseConfigFromJson(question.getVoteCountingConfig());
    }

    public VoteCountingStrategy<?> initVoteCountingStrategy(Question question) {
        VoteCounting voteCounting = this.getVoteCounting(question);
        VoteCountingStrategy strategy = voteCounting.newStrategy();
        String voteCountingConfigJson = question.getVoteCountingConfig();
        strategy.setConfigFromJson(voteCountingConfigJson);
        return strategy;
    }

    public VoteCountingResultBean getSimpleResult(String questionId) {
        Preconditions.checkNotNull((Object)questionId);
        Question question = this.getQuestionService().getQuestion0(questionId);
        List<Vote> votes = this.getVotes(question);
        VoteCountingStrategy<?> strategy = this.initVoteCountingStrategy(question);
        ListOfVoter groupOfVoter = this.toSimpleVotersGroup(votes);
        ListVoteCountingResult groupVoteCountingResult = strategy.voteCount(groupOfVoter);
        VoteCountingResult mainResult = groupVoteCountingResult.getMainResult();
        VoteCountingResultBean result = new VoteCountingResultBean();
        result.fromResult(mainResult);
        return result;
    }

    protected List<Vote> getVotes(Question question) {
        List votes = this.getVoteDao().findAllByQuestion(question);
        int maxVoters = this.getPollService().getMaxVoters(question.getPoll());
        if (maxVoters > 0 && votes.size() > maxVoters) {
            votes = votes.subList(0, maxVoters);
        }
        return votes;
    }

    public ListVoteCountingResultBean getGroupResult(String questionId) {
        Preconditions.checkNotNull((Object)questionId);
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.readResult(question));
        VoterList mainVoterList = this.getVoterListService().getMainVoterList0(question.getPoll());
        List<Vote> votes = this.getVotes(question);
        VoteCountingStrategy<?> strategy = this.initVoteCountingStrategy(question);
        ListOfVoter listOfVoter = this.toListOfVoters(question, mainVoterList, votes);
        ListVoteCountingResult groupVoteCountingResult = strategy.voteCount(listOfVoter);
        ListVoteCountingResultBean result = new ListVoteCountingResultBean();
        result.fromResult(groupVoteCountingResult);
        return result;
    }

    protected ListOfVoter toSimpleVotersGroup(List<Vote> votes) {
        Preconditions.checkNotNull(votes);
        HashSet voters = Sets.newHashSet();
        for (Vote vote : votes) {
            SimpleVoter simpleVoter = this.toSimpleVoter(vote);
            voters.add(simpleVoter);
        }
        return ListOfVoter.newVoter(null, (double)1.0, (Set)voters);
    }

    protected ListOfVoter toListOfVoters(Question question, VoterList voterList, List<Vote> votes) {
        Preconditions.checkNotNull((Object)question);
        Preconditions.checkNotNull((Object)voterList);
        Preconditions.checkNotNull(votes);
        Preconditions.checkArgument((boolean)Polls.isPollRestricted(question.getPoll()), (Object)"Can only use this method for a restricted poll");
        return this.toListOfVoters(voterList, votes);
    }

    protected ListOfVoter toListOfVoters(VoterList voterList, List<Vote> votes) {
        HashSet voters = Sets.newHashSet();
        List subVoterLists = this.getVoterListDao().forParentEquals(voterList).findAll();
        for (VoterList subVoterList : subVoterLists) {
            ListOfVoter subListOfVoter = this.toListOfVoters(subVoterList, votes);
            voters.add(subListOfVoter);
        }
        List<VoterListMember> voterListMembers = this.getVoterListService().getVoterListMembers0(voterList);
        for (VoterListMember voterListMember : voterListMembers) {
            Optional<Vote> voteOptional = votes.stream().filter(vote -> vote.getVoterListMember().contains(voterListMember)).findFirst();
            if (!voteOptional.isPresent()) continue;
            SimpleVoter simpleVoter = this.toSimpleVoter(voteOptional.get());
            simpleVoter.setWeight(voterListMember.getWeight());
            voters.add(simpleVoter);
        }
        return ListOfVoter.newVoter((String)voterList.getTopiaId(), (double)voterList.getWeight(), (Set)voters);
    }

    protected SimpleVoter toSimpleVoter(Vote vote) {
        HashSet voteForChoices = Sets.newHashSet();
        if (!vote.isVoteToChoiceEmpty()) {
            for (VoteToChoice voteToChoice : vote.getVoteToChoice()) {
                VoteForChoice voteForChoice = VoteForChoice.newVote((String)voteToChoice.getChoice().getTopiaId(), (Double)voteToChoice.getVoteValue());
                voteForChoices.add(voteForChoice);
            }
        }
        return SimpleVoter.newVoter((String)vote.getVoter().getTopiaId(), (double)vote.getWeight(), (Set)voteForChoices);
    }

    protected SimpleVoter toSimpleVoter(VoteBean vote) {
        Set voteForChoices = vote.getChoice().stream().map(voteToChoice -> VoteForChoice.newVote((String)voteToChoice.getChoiceId().getEntityId(), (Double)voteToChoice.getVoteValue())).collect(Collectors.toSet());
        return SimpleVoter.newVoter((String)vote.getVoterId().getEntityId(), (double)vote.getWeight(), voteForChoices);
    }

    protected VoteCounting getVoteCounting(Question question) {
        int id = question.getVoteCountingType();
        VoteCountings voteCountingType = VoteCountings.forLegacyId((int)id);
        VoteCountingFactory voteCountingFactory = this.serviceContext.getVoteCountingFactory();
        VoteCounting result = voteCountingFactory.getVoteCounting(voteCountingType);
        Preconditions.checkNotNull((Object)result, (Object)("Could not find vote counting for id " + id));
        return result;
    }

    protected ErrorMap validateVote(VoteBean vote, VoteCounting voteCounting, VoteCountingConfig config) {
        ErrorMap errorMap = new ErrorMap();
        SimpleVoter simpleVoter = this.toSimpleVoter(vote);
        Multimap errors = voteCounting.validateVote((Voter)simpleVoter, config, this.getLocale());
        errorMap.addAllErrors((Multimap<String, String>)errors);
        return errorMap;
    }
}

