/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.WeakHashMap;
import org.chorem.pollen.persistence.PollenFlywayService;
import org.chorem.pollen.persistence.PollenPersistenceConfiguration;
import org.chorem.pollen.persistence.PollenPersistenceConfigurationBuilder;
import org.chorem.pollen.persistence.PollenPersistenceContext;
import org.chorem.pollen.persistence.PollenPersistenceUtil;
import org.chorem.pollen.persistence.topia.TopiaException;
import org.chorem.pollen.persistence.topia.internal.HibernateProvider;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollenApplicationContext
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(PollenApplicationContext.class);
    protected PollenPersistenceConfiguration configuration;
    protected PollenFlywayService migrationService;
    protected HibernateProvider hibernateProvider;
    protected boolean closed = false;
    protected Set<PollenPersistenceContext> persistenceContexts = Collections.newSetFromMap(new WeakHashMap());

    public void init() {
        new PollenPersistenceConfigurationBuilder().check(this.configuration);
        this.initMigrationService();
        if (this.isInitSchema()) {
            log.debug("Schema initialization enabled");
            this.initSchema();
        } else {
            log.debug("Schema initialization disabled");
        }
        this.getHibernateProvider().getHibernateConfiguration();
    }

    protected void initMigrationService() {
        this.migrationService = new PollenFlywayService(this.getConfiguration());
    }

    protected boolean isInitSchema() {
        return this.configuration.isInitSchema();
    }

    public void initSchema() {
        if (this.isSchemaEmpty()) {
            log.debug("schema is empty, will create");
            this.createSchema();
            log.debug("schema created, will call migration service");
            this.migrationService.initOnCreateSchema();
        } else {
            log.debug("schema exists, will try to migrate");
            this.migrationService.runSchemaMigration();
        }
    }

    private HibernateProvider getHibernateProvider() {
        if (this.hibernateProvider == null) {
            this.hibernateProvider = new HibernateProvider(this.getConfiguration());
        }
        return this.hibernateProvider;
    }

    public PollenPersistenceConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isSchemaEmpty() {
        Configuration configuration = this.getHibernateProvider().newHibernateConfiguration();
        configuration.getProperties().put("hibernate.hbm2ddl.auto", "none");
        try (SessionFactory sessionFactory = this.hibernateProvider.newSessionFactory(configuration);){
            Metadata metaData = this.getHibernateProvider().newMetaData(configuration, sessionFactory);
            boolean bl = PollenPersistenceUtil.isSchemaEmpty(configuration, metaData);
            return bl;
        }
    }

    @Deprecated
    public String getSchemaName() {
        return this.getConfiguration().getSchemaName();
    }

    public void createSchema() {
        try {
            EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.DATABASE);
            if (log.isDebugEnabled()) {
                targetTypes.add(TargetType.STDOUT);
            }
            Configuration configuration = this.getHibernateProvider().newHibernateConfiguration();
            configuration.getProperties().remove("hibernate.hbm2ddl.auto");
            try (SessionFactory sessionFactory = this.getHibernateProvider().newSessionFactory(configuration);){
                Metadata metadata = this.getHibernateProvider().newMetaData(configuration, sessionFactory);
                new SchemaExport().execute(targetTypes, SchemaExport.Action.CREATE, metadata);
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("Could not create schema for reason: %s", eee.getMessage()), eee);
        }
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"PollenApplicationContext was already closed");
        log.debug("will close {}", (Object)this);
        for (PollenPersistenceContext persistenceContext : this.persistenceContexts) {
            if (persistenceContext == null) {
                log.warn("null PollenPersistenceContext found in #persistenceContexts");
                continue;
            }
            try {
                if (persistenceContext.isClosed()) continue;
                persistenceContext.close();
            }
            catch (Exception eee) {
                log.warn("unable to close PollenPersistenceContext", (Throwable)eee);
            }
        }
        this.hibernateProvider.close();
        this.closed = true;
        log.debug("{} closed", (Object)this);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public PollenPersistenceContext newPersistenceContext() {
        PollenPersistenceContext newContext = new PollenPersistenceContext(this.getHibernateProvider(), this.getConfiguration().getSlowQueriesThreshold(), this::onPollenPersistenceContextClosed);
        this.persistenceContexts.add(newContext);
        return newContext;
    }

    private void onPollenPersistenceContextClosed(PollenPersistenceContext persistenceContext) {
        this.persistenceContexts.remove(persistenceContext);
    }

    public PollenApplicationContext(PollenPersistenceConfiguration configuration) {
        this.configuration = configuration;
    }

    public long countOpenedTransactions() {
        return this.persistenceContexts.stream().filter(ppc -> !ppc.isClosed()).count();
    }
}

