/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.entity;

import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.chorem.pollen.persistence.AbstractPollenDao;
import org.chorem.pollen.persistence.entity.PollenToken;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.SessionToken;
import org.chorem.pollen.persistence.topia.HqlAndParametersBuilder;
import org.chorem.pollen.persistence.topia.query.AddCriteriaOrRunQueryStep;

public class SessionTokenDao
extends AbstractPollenDao<SessionToken> {
    @Override
    public Class<SessionToken> getEntityClass() {
        return SessionToken.class;
    }

    @Override
    public void delete(SessionToken entity) {
        if (!entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + String.valueOf(entity) + " is not persisted, you can't delete it");
        }
        super.delete(entity);
    }

    public Set<SessionToken> findAllBeforeEndDate(Date now) {
        HqlAndParametersBuilder builder = this.newHqlAndParametersBuilder();
        builder.addLowerThan("pollenToken.endDate", now);
        List sessionTokens = this.findAll(builder.getHql(), builder.getHqlParameters());
        return ImmutableSet.copyOf(sessionTokens);
    }

    public AddCriteriaOrRunQueryStep<SessionToken> forPollenTokenEquals(PollenToken v) {
        return this.forEquals("pollenToken", v);
    }

    public AddCriteriaOrRunQueryStep<SessionToken> forPollenUserEquals(PollenUser v) {
        return this.forEquals("pollenUser", v);
    }
}

