/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen;

import java.io.File;
import java.net.URL;
import org.chorem.pollen.business.persistence.ChoiceType;
import org.chorem.pollen.business.persistence.PollCommentVisibility;
import org.chorem.pollen.business.persistence.PollType;
import org.chorem.pollen.business.persistence.PollVoteVisibility;
import org.h2.Driver;
import org.hibernate.dialect.H2Dialect;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;

public enum PollenConfigurationOption implements ApplicationConfig.OptionDef
{
    APPLICATION_URL("siteUrl", I18n.n_((String)"pollen.configuration.siteUrl", (Object[])new Object[0]), "", URL.class),
    DATA_DIR("pollen.dataDirectory", I18n.n_((String)"pollen.configuration.dataDirectory", (Object[])new Object[0]), "/var/local/pollen/data", File.class),
    ADMIN_LOGIN("adminLogin", I18n.n_((String)"pollen.configuration.db.login", (Object[])new Object[0]), "admin", String.class),
    ADMIN_PASSWORD("adminPassword", I18n.n_((String)"pollen.configuration.db.password", (Object[])new Object[0]), "pollen", String.class),
    ADMIN_EMAIL("adminEmail", I18n.n_((String)"pollen.configuration.adminEmail", (Object[])new Object[0]), "admin@domain.com", String.class),
    CONTACT_EMAIL("contactEmail", I18n.n_((String)"pollen.configuration.contactEmail", (Object[])new Object[0]), "", String.class),
    EMAIL_HOST("email_host", I18n.n_((String)"pollen.configuration.emailHost", (Object[])new Object[0]), "smtp", String.class),
    EMAIL_PORT("email_port", I18n.n_((String)"pollen.configuration.emailPort", (Object[])new Object[0]), "25", String.class),
    EMAIL_FROM("email_from", I18n.n_((String)"pollen.configuration.emailFrom", (Object[])new Object[0]), "bot@pollen.org", String.class),
    EMAIL_DIR("pollen.emails.directory", I18n.n_((String)"pollen.configuration.emaiDirectory", (Object[])new Object[0]), "${pollen.dataDirectory}/emails", File.class),
    FEED_DIR("feedDir", I18n.n_((String)"pollen.configuration.feedDirectory", (Object[])new Object[0]), "${pollen.dataDirectory}/feeds", File.class),
    IMG_DIR("upImgDir", I18n.n_((String)"pollen.configuration.imageDirectory", (Object[])new Object[0]), "${pollen.dataDirectory}/uploadedImages", File.class),
    TMP_DIR("tmpDir", I18n.n_((String)"pollen.configuration.tmpDirectory", (Object[])new Object[0]), "${pollen.dataDirectory}/tmp", File.class),
    NB_VOTES_PER_PAGE("pollen.ui.nbVotesPerPage", I18n.n_((String)"pollen.configuration.nbVoteByPage", (Object[])new Object[0]), "25", Integer.TYPE),
    CHARSET("pollen.charset", I18n.n_((String)"pollen.configuration.charset", (Object[])new Object[0]), "UTF-8", String.class),
    DEFAULT_POLL_TYPE("pollen.default.pollType", I18n.n_((String)"pollen.configuration.defaultPollType", (Object[])new Object[0]), PollType.FREE.name(), PollType.class),
    DEFAULT_VOTE_COUNTING_TYPE("pollen.default.voteCountingType", I18n.n_((String)"pollen.configuration.defaultVoteCountingType", (Object[])new Object[0]), "0", Integer.class),
    DEFAULT_CHOICE_TYPE("pollen.default.choiceType", I18n.n_((String)"pollen.configuration.defaultChoiceType", (Object[])new Object[0]), ChoiceType.TEXT.name(), ChoiceType.class),
    DEFAULT_POLL_VOTE_VISIBILITY("pollen.default.pollVoteVisibility", I18n.n_((String)"pollen.configuration.defaultPollVoteVisibility", (Object[])new Object[0]), PollVoteVisibility.EVERYBODY.name(), PollVoteVisibility.class),
    DEFAULT_POLL_COMMENT_VISIBILITY("pollen.default.pollCommentVisibility", I18n.n_((String)"pollen.configuration.defaultPollCommentVisibility", (Object[])new Object[0]), PollCommentVisibility.EVERYBODY.name(), PollCommentVisibility.class),
    DB_DRIVER("hibernate.connection.driver_class", I18n.n_((String)"pollen.configuration.dbDriver", (Object[])new Object[0]), Driver.class.getName(), Class.class),
    DB_DIALECT("hibernate.dialect", I18n.n_((String)"pollen.configuration.dbDialect", (Object[])new Object[0]), H2Dialect.class.getName(), Class.class),
    DB_URL("hibernate.connection.url", I18n.n_((String)"pollen.configuration.dbUrl", (Object[])new Object[0]), "jdbc:h2:file:${pollen.dataDirectory}/db/pollendb", String.class),
    DB_LOGIN("hibernate.connection.username", I18n.n_((String)"pollen.configuration.dbLogin", (Object[])new Object[0]), "sa", String.class),
    DB_PASSWORD("hibernate.connection.password", I18n.n_((String)"pollen.configuration.dbPassword", (Object[])new Object[0]), "", String.class);

    protected final String key;
    protected final String description;
    protected final Class<?> type;
    protected String defaultValue;

    private PollenConfigurationOption(String key, String description, String defaultValue, Class<?> type) {
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isFinal() {
        return false;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setTransient(boolean newValue) {
    }

    public void setFinal(boolean newValue) {
    }
}

