/*
 * #%L
 * Pollen :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.List;
import org.chorem.pollen.common.VoteCountingType;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class ResultAbstract extends TopiaEntityAbstract implements Result {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : resultValue
     */
    protected String resultValue;

    /**
     * Nom de l'attribut en BD : byGroup
     */
    protected boolean byGroup;

    /**
     * Nom de l'attribut en BD : poll
     */
    protected Poll poll;

    /**
     * Nom de l'attribut en BD : voteCountingType
     */
    protected VoteCountingType voteCountingType;

    private static final long serialVersionUID = 7149517414326231649L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_RESULT_VALUE, String.class, resultValue);
        visitor.visit(this, PROPERTY_BY_GROUP, boolean.class, byGroup);
        visitor.visit(this, PROPERTY_POLL, Poll.class, poll);
        visitor.visit(this, PROPERTY_VOTE_COUNTING_TYPE, VoteCountingType.class, voteCountingType);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setResultValue(String resultValue) {
        String oldValue = this.resultValue;
        fireOnPreWrite(PROPERTY_RESULT_VALUE, oldValue, resultValue);
        this.resultValue = resultValue;
        fireOnPostWrite(PROPERTY_RESULT_VALUE, oldValue, resultValue);
    }

    @Override
    public String getResultValue() {
        fireOnPreRead(PROPERTY_RESULT_VALUE, resultValue);
        String result = this.resultValue;
        fireOnPostRead(PROPERTY_RESULT_VALUE, resultValue);
        return result;
    }

    @Override
    public void setByGroup(boolean byGroup) {
        boolean oldValue = this.byGroup;
        fireOnPreWrite(PROPERTY_BY_GROUP, oldValue, byGroup);
        this.byGroup = byGroup;
        fireOnPostWrite(PROPERTY_BY_GROUP, oldValue, byGroup);
    }

    @Override
    public boolean isByGroup() {
        fireOnPreRead(PROPERTY_BY_GROUP, byGroup);
        boolean result = this.byGroup;
        fireOnPostRead(PROPERTY_BY_GROUP, byGroup);
        return result;
    }

    @Override
    public void setPoll(Poll poll) {
        Poll oldValue = this.poll;
        fireOnPreWrite(PROPERTY_POLL, oldValue, poll);
        this.poll = poll;
        fireOnPostWrite(PROPERTY_POLL, oldValue, poll);
    }

    @Override
    public Poll getPoll() {
        fireOnPreRead(PROPERTY_POLL, poll);
        Poll result = this.poll;
        fireOnPostRead(PROPERTY_POLL, poll);
        return result;
    }

    @Override
    public void setVoteCountingType(VoteCountingType voteCountingType) {
        VoteCountingType oldValue = this.voteCountingType;
        fireOnPreWrite(PROPERTY_VOTE_COUNTING_TYPE, oldValue, voteCountingType);
        this.voteCountingType = voteCountingType;
        fireOnPostWrite(PROPERTY_VOTE_COUNTING_TYPE, oldValue, voteCountingType);
    }

    @Override
    public VoteCountingType getVoteCountingType() {
        fireOnPreRead(PROPERTY_VOTE_COUNTING_TYPE, voteCountingType);
        VoteCountingType result = this.voteCountingType;
        fireOnPostRead(PROPERTY_VOTE_COUNTING_TYPE, voteCountingType);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //ResultAbstract
