/**
 * *##% Callao NumberUtil
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.utils;


import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Cette classe permet de manipuler des nombres.
 * Elle est utilisée essentiellement au niveau des entrées comptables afin de
 * formater tous les nombres suivant la norme comptabilité choisie.
 * @author Rémi Chapelet
 */
public class NumberUtil {

    /** log */
    private static final Log log = LogFactory.getLog(NumberUtil.class);

    public static NumberFormat numberFormat;

    public static final String format = "%0$10.2f";


    /**
     * Instancie la classe NumberFormat. Elle va permettre d'apporter des méthodes
     * pour manipuler les chaines de caractères et les nombres.
     * On doit définir la variable locale.
     * @return
     */
    public static NumberFormat getNumberFormat() {
        if (numberFormat == null) {
            numberFormat = NumberFormat.getNumberInstance(Locale.FRENCH);
        }
        return numberFormat;
    }

    /**
     * Format la chaine de caractère en nombre.
     * @param amount
     */
    public Double formatNumber (String amount)
    {
        Double numberDouble;
        try {
            Number number = getNumberFormat().parse(amount);
            numberDouble = number.doubleValue();
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return numberDouble;
    }


    /**
     * Formate un nombre sous format Double en renvoyant en chaîne de caractère.
     * Il utilise la variable "format" pour définir le formatage ainsi que la
     * variable locale.
     * @param number
     * @return
     */
    public String format(double number)
    {
        return String.format(Locale.FRENCH, format, number).trim();
    }

    /**
     * Formate un nombre sous format String.
     * @param theDouble
     * @return
     */
    public String format(String amount)
    {
        return format(formatNumber(amount));
    }




}