/**
 * *##% Callao ConvertLog
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.convertObject;


import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.Log;
import org.chorem.callao.service.dto.LogDTO;

/**
 * Transforme les objets Log : DTO, DAO et entity
 *
 * @author Rémi Chapelet
 */
public class ConvertLog  extends ConvertTopiaContext {

    private static final org.apache.commons.logging.Log log = LogFactory.getLog(ConvertAccount.class);


    /**
     * Permet de transformer une entité journal en objet DTO
     * @param journal
     * @return
     */
    public LogDTO logEntityToDto(Log log)
    {
        LogDTO logDTO = new LogDTO();
        logDTO.setId(log.getTopiaId());
        logDTO.setLogDate(log.getLogDate());
        logDTO.setType(log.getType());
        logDTO.setTransDate(log.getTransDate());
        logDTO.setVoucherRef(log.getVoucherRef());
        logDTO.setTransDesc(log.getTransDesc());
        logDTO.setEntryDesc(log.getEntryDesc());
        logDTO.setAmount(log.getAmount());
        logDTO.setDebit(log.getDebit());
        logDTO.setLettering(log.getLettering());
        return logDTO;
    }


}