/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.util.List;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
@Import(library={"../Chenillekit.js", "Accordion.js"}, stylesheet={"Accordion.css"})
public class Accordion
implements ClientElement {
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(required=true)
    private List<?> subjects;
    @Parameter(required=true)
    private List<?> details;
    @Parameter(value="false", required=false)
    private boolean renderDetailsRaw;
    @Parameter(value="0.2", required=false)
    private String duration;
    @Inject
    private ComponentResources resources;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private Environment environment;
    private String assignedClientId;

    void setupRender() {
        this.assignedClientId = this.javascriptSupport.allocateClientId(this.clientId);
    }

    void beginRender(MarkupWriter writer) {
        writer.element("div", new Object[]{"id", this.getClientId()});
        this.resources.renderInformalParameters(writer);
        Object[] subjectsArray = this.subjects.toArray();
        Object[] detailsArray = this.details.toArray();
        for (int i = 0; i < subjectsArray.length; ++i) {
            String subject = subjectsArray[i].toString();
            String detail = "";
            if (detailsArray.length >= i + 1) {
                detail = detailsArray[i].toString();
            }
            writer.element("div", new Object[]{"id", this.getClientId() + "_toggle_" + i, "class", "ck_accordionToggle"});
            writer.write(subject);
            writer.end();
            writer.element("div", new Object[]{"id", this.getClientId() + "_content_" + i, "class", "ck_accordionContent", "style", "display: none;"});
            writer.element("div", new Object[0]);
            if (this.renderDetailsRaw) {
                writer.writeRaw(detail);
            } else {
                writer.write(detail);
            }
            writer.end();
            writer.end();
        }
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
        this.javascriptSupport.addScript("new Ck.Accordion('%s', {duration: %s});", new Object[]{this.getClientId(), this.duration});
    }

    public String getClientId() {
        return this.assignedClientId;
    }
}

