/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary.impl;

import boofcv.alg.filter.binary.ThresholdBlock;
import boofcv.alg.filter.binary.ThresholdBlockMean;
import boofcv.struct.image.GrayU8;

public class ThresholdBlockMean_U8
extends ThresholdBlockMean<GrayU8> {
    double scale;

    public ThresholdBlockMean_U8(double scale, boolean down) {
        super(down);
        this.scale = scale;
    }

    @Override
    public void thresholdBlock(int blockX0, int blockY0, GrayU8 input, GrayU8 stats, GrayU8 output) {
        int y;
        int blockY1;
        int blockX1;
        int y1;
        int x0 = blockX0 * this.blockWidth;
        int y0 = blockY0 * this.blockHeight;
        int x1 = blockX0 == stats.width - 1 ? input.width : (blockX0 + 1) * this.blockWidth;
        int n = y1 = blockY0 == stats.height - 1 ? input.height : (blockY0 + 1) * this.blockHeight;
        if (this.thresholdFromLocalBlocks) {
            blockX1 = Math.min(stats.width - 1, blockX0 + 1);
            blockY1 = Math.min(stats.height - 1, blockY0 + 1);
            blockX0 = Math.max(0, blockX0 - 1);
            blockY0 = Math.max(0, blockY0 - 1);
        } else {
            blockX1 = blockX0;
            blockY1 = blockY0;
        }
        int mean = 0;
        for (y = blockY0; y <= blockY1; ++y) {
            for (int x = blockX0; x <= blockX1; ++x) {
                mean += stats.unsafe_get(x, y);
            }
        }
        mean /= (blockY1 - blockY0 + 1) * (blockX1 - blockX0 + 1);
        for (y = y0; y < y1; ++y) {
            int indexInput = input.startIndex + y * input.stride + x0;
            int indexOutput = output.startIndex + y * output.stride + x0;
            int end = indexOutput + (x1 - x0);
            while (indexOutput < end) {
                output.data[indexOutput] = (input.data[indexInput] & 0xFF) <= mean ? this.a : this.b;
                ++indexOutput;
                ++indexInput;
            }
        }
    }

    @Override
    public ThresholdBlock.BlockProcessor<GrayU8, GrayU8> copy() {
        return new ThresholdBlockMean_U8(this.scale, this.isDown());
    }

    @Override
    public GrayU8 createStats() {
        return new GrayU8(1, 1);
    }

    @Override
    public void computeBlockStatistics(int x0, int y0, int width, int height, int indexStats, GrayU8 input, GrayU8 stats) {
        int sum = 0;
        for (int y = 0; y < height; ++y) {
            int indexInput = input.startIndex + (y0 + y) * input.stride + x0;
            for (int x = 0; x < width; ++x) {
                sum += input.data[indexInput++] & 0xFF;
            }
        }
        sum = (int)(this.scale * (double)sum / (double)(width * height) + 0.5);
        stats.data[indexStats] = (byte)sum;
    }
}

