/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.transform.wavelet.impl;

import boofcv.abst.transform.wavelet.WaveletTransform;
import boofcv.alg.transform.wavelet.UtilWavelet;
import boofcv.alg.transform.wavelet.WaveletTransformOps;
import boofcv.core.image.GConvertImage;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDimension;
import boofcv.struct.image.ImageGray;
import boofcv.struct.wavelet.WaveletDescription;
import boofcv.struct.wavelet.WlCoef_I32;
import org.jetbrains.annotations.Nullable;

public class WaveletTransformInt<T extends GrayI<T>>
implements WaveletTransform<T, GrayS32, WlCoef_I32> {
    GrayS32 copyInput = new GrayS32(1, 1);
    GrayS32 copyOutput = new GrayS32(1, 1);
    GrayS32 temp = new GrayS32(1, 1);
    WaveletDescription<WlCoef_I32> desc;
    int numLevels;
    Class<T> inputType;
    int minPixelValue;
    int maxPixelValue;

    public WaveletTransformInt(WaveletDescription<WlCoef_I32> desc, int numLevels, int minPixelValue, int maxPixelValue, Class<T> inputType) {
        this.desc = desc;
        this.numLevels = numLevels;
        this.inputType = inputType;
        this.minPixelValue = minPixelValue;
        this.maxPixelValue = maxPixelValue;
    }

    @Override
    public GrayS32 transform(T original, @Nullable GrayS32 transformed) {
        if (transformed == null) {
            ImageDimension d = UtilWavelet.transformDimension(original, this.numLevels);
            transformed = new GrayS32(d.width, d.height);
        }
        this.temp.reshape(transformed.width, transformed.height);
        this.copyInput.reshape(((GrayI)original).width, ((GrayI)original).height);
        if (original.getDataType().getDataType() == Integer.TYPE) {
            this.copyInput.setTo((ImageGray)((GrayS32)original));
        } else {
            GConvertImage.convert(original, (ImageBase)this.copyInput);
        }
        WaveletTransformOps.transformN(this.desc, this.copyInput, transformed, this.temp, this.numLevels);
        return transformed;
    }

    @Override
    public void invert(GrayS32 transformed, T original) {
        this.copyInput.reshape(transformed.width, transformed.height);
        this.temp.reshape(transformed.width, transformed.height);
        this.copyInput.setTo((ImageGray)transformed);
        if (original.getDataType().getDataType() == Integer.TYPE) {
            WaveletTransformOps.inverseN(this.desc, this.copyInput, (GrayS32)original, this.temp, this.numLevels, this.minPixelValue, this.maxPixelValue);
        } else {
            this.copyOutput.reshape(((GrayI)original).width, ((GrayI)original).height);
            WaveletTransformOps.inverseN(this.desc, this.copyInput, this.copyOutput, this.temp, this.numLevels, this.minPixelValue, this.maxPixelValue);
            GConvertImage.convert((ImageBase)this.copyOutput, original);
        }
    }

    @Override
    public int getLevels() {
        return this.numLevels;
    }

    @Override
    public BorderType getBorderType() {
        return UtilWavelet.convertToType(this.desc.getBorder());
    }

    @Override
    public WaveletDescription<WlCoef_I32> getDescription() {
        return this.desc;
    }

    @Override
    public Class<T> getOriginalType() {
        return this.inputType;
    }
}

