/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.chem;

import java.io.IOException;
import java.io.InputStream;
import org.biojava.nbio.structure.chem.ChemComp;
import org.biojava.nbio.structure.chem.ChemCompProvider;
import org.biojava.nbio.structure.chem.ChemicalComponentDictionary;
import org.biojava.nbio.structure.io.cif.ChemCompConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReducedChemCompProvider
implements ChemCompProvider {
    private static final Logger logger = LoggerFactory.getLogger(ReducedChemCompProvider.class);

    public ReducedChemCompProvider() {
        logger.debug("Initialising ReducedChemCompProvider");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ChemComp getChemComp(String recordName) {
        String name = recordName.toUpperCase().trim();
        try (InputStream inStream = this.getClass().getResourceAsStream("/chemcomp/" + name + ".cif.gz");){
            logger.debug("Reading chemcomp/{}.cif.gz", (Object)recordName);
            if (inStream == null) {
                logger.debug("Getting empty chem comp for {}", (Object)name);
                ChemComp cc = ChemComp.getEmptyChemComp();
                cc.setId(name);
                ChemComp chemComp2 = cc;
                return chemComp2;
            }
            ChemicalComponentDictionary dict = ChemCompConverter.fromInputStream(inStream);
            ChemComp chemComp = dict.getChemComp(name);
            return chemComp;
        }
        catch (IOException e) {
            logger.error("IOException caught while reading chem comp {}.", (Object)name, (Object)e);
            logger.warn("Problem when loading chem comp {}, will use an empty chem comp for it", (Object)name);
            ChemComp cc = ChemComp.getEmptyChemComp();
            cc.setId(name);
            return cc;
        }
    }
}

