/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.pairwise;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.align.helper.JointFragments;
import org.biojava.nbio.structure.align.pairwise.FragmentPair;
import org.biojava.nbio.structure.jama.Matrix;

public class AlignmentProgressListener {
    String n1;
    String n2;
    int l1;
    int l2;
    Atom[] ca1;
    Atom[] ca2;

    public void startingAlignment(String name1, Atom[] ca1, String name2, Atom[] ca2) {
        this.n1 = name1;
        this.n2 = name2;
        this.l1 = ca1.length;
        this.l2 = ca2.length;
        this.ca1 = ca1;
        this.ca2 = ca2;
    }

    public void calculatedFragmentPairs(List<FragmentPair> fragments) {
        System.out.println("got: " + fragments.size() + " fragments");
        String title = "Initial FragmentPairs for:" + this.n1 + "(" + this.l1 + ") vs. " + this.n2 + " (" + this.l2 + ")";
        Matrix m = new Matrix(this.l1, this.l2, 99.0);
        for (FragmentPair p : fragments) {
            for (FragmentPair pair2 : fragments) {
                int p2;
                int p1;
                int i;
                Atom v1 = p.getUnitv();
                Atom v2 = pair2.getUnitv();
                double dist = Calc.getDistance(v1, v2);
                for (i = 0; i < p.getLength(); ++i) {
                    p1 = p.getPos1();
                    p2 = p.getPos2();
                    m.set(p1 + i, p2 + i, dist);
                }
                for (i = 0; i < pair2.getLength(); ++i) {
                    p1 = pair2.getPos1();
                    p2 = pair2.getPos2();
                    m.set(p1 + i, p2 + i, dist);
                }
            }
        }
        JFrame frame = new JFrame();
        frame.setTitle(title);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JFrame f = (JFrame)e.getSource();
                f.setVisible(false);
                f.dispose();
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    public void jointFragments(JointFragments[] fragments) {
        System.out.println("numberof Joint fragments: " + fragments.length);
        String title = "JointFragment for:" + this.n1 + "(" + this.l1 + ") vs. " + this.n2 + " (" + this.l2 + ")";
        Matrix m = new Matrix(this.l1, this.l2, 99.0);
        for (JointFragments p : fragments) {
            for (int[] idx : p.getIdxlist()) {
                m.set(idx[0], idx[1], p.getRms());
            }
        }
        JFrame frame = new JFrame();
        frame.setTitle(title);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JFrame f = (JFrame)e.getSource();
                f.setVisible(false);
                f.dispose();
            }
        });
        frame.pack();
        frame.setVisible(true);
        for (JointFragments f : fragments) {
            System.out.println(f);
        }
    }
}

