/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.secstruc;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupIterator;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.secstruc.SecStrucElement;
import org.biojava.nbio.structure.secstruc.SecStrucInfo;
import org.biojava.nbio.structure.secstruc.SecStrucType;

public class SecStrucTools {
    public static List<SecStrucInfo> getSecStrucInfo(Structure s) {
        ArrayList<SecStrucInfo> listSSI = new ArrayList<SecStrucInfo>();
        GroupIterator iter = new GroupIterator(s);
        while (iter.hasNext()) {
            Object p;
            Group g = iter.next();
            if (!g.hasAminoAtoms() || (p = g.getProperty("secstruc")) == null) continue;
            SecStrucInfo ss = (SecStrucInfo)p;
            listSSI.add(ss);
        }
        return listSSI;
    }

    public static void assignSecStruc(Structure s, List<SecStrucInfo> listSSI) {
        for (SecStrucInfo ssi : listSSI) {
            ssi.getGroup().setProperty("secstruc", ssi);
        }
    }

    public static List<SecStrucElement> getSecStrucElements(Structure s) {
        ArrayList<SecStrucElement> listSSE = new ArrayList<SecStrucElement>();
        GroupIterator iter = new GroupIterator(s);
        SecStrucType type = SecStrucType.coil;
        ResidueNumber previous = new ResidueNumber();
        ResidueNumber start = new ResidueNumber();
        String chainId = "";
        int count = 0;
        TreeMap<SecStrucType, Integer> ids = new TreeMap<SecStrucType, Integer>();
        for (SecStrucType t : SecStrucType.values()) {
            ids.put(t, 1);
        }
        while (iter.hasNext()) {
            Object p;
            Group g = iter.next();
            if (!g.hasAminoAtoms() || (p = g.getProperty("secstruc")) == null) continue;
            SecStrucInfo ss = (SecStrucInfo)p;
            if (count > 0) {
                if (ss.type == type && chainId == g.getChainId()) {
                    previous = g.getResidueNumber();
                    ++count;
                    continue;
                }
                SecStrucElement sse = new SecStrucElement(type, start, previous, count, (Integer)ids.get((Object)type), chainId);
                listSSE.add(sse);
                ids.put(type, (Integer)ids.get((Object)type) + 1);
                count = 0;
                if (ss.type == SecStrucType.coil) continue;
                type = ss.type;
                previous = start = g.getResidueNumber();
                chainId = g.getChainId();
                count = 1;
                continue;
            }
            if (ss.type == SecStrucType.coil) continue;
            type = ss.type;
            previous = start = g.getResidueNumber();
            chainId = g.getChainId();
            count = 1;
        }
        return listSSE;
    }

    public static List<SecStrucElement> getSecStrucElements(List<Group> groups) {
        ArrayList<SecStrucElement> listSSE = new ArrayList<SecStrucElement>();
        SecStrucType type = SecStrucType.coil;
        ResidueNumber previous = new ResidueNumber();
        ResidueNumber start = new ResidueNumber();
        String chainId = "";
        int count = 0;
        TreeMap<SecStrucType, Integer> ids = new TreeMap<SecStrucType, Integer>();
        for (SecStrucType t : SecStrucType.values()) {
            ids.put(t, 1);
        }
        for (Group g : groups) {
            Object p;
            if (!g.hasAminoAtoms() || (p = g.getProperty("secstruc")) == null) continue;
            SecStrucInfo ss = (SecStrucInfo)p;
            if (count > 0) {
                if (ss.type == type && chainId == g.getChainId()) {
                    previous = g.getResidueNumber();
                    ++count;
                    continue;
                }
                SecStrucElement sse = new SecStrucElement(type, start, previous, count, (Integer)ids.get((Object)type), chainId);
                listSSE.add(sse);
                ids.put(type, (Integer)ids.get((Object)type) + 1);
                count = 0;
                if (ss.type == SecStrucType.coil) continue;
                type = ss.type;
                previous = start = g.getResidueNumber();
                chainId = g.getChainId();
                count = 1;
                continue;
            }
            if (ss.type == SecStrucType.coil) continue;
            type = ss.type;
            previous = start = g.getResidueNumber();
            chainId = g.getChainId();
            count = 1;
        }
        return listSSE;
    }
}

