/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmtf;

import java.util.List;
import java.util.Map;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Bond;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.PDBCrystallographicInfo;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.biojava.nbio.structure.io.mmtf.MmtfSummaryDataBean;
import org.biojava.nbio.structure.io.mmtf.MmtfUtils;
import org.biojava.nbio.structure.quaternary.BioAssemblyInfo;
import org.rcsb.mmtf.api.StructureAdapterInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MmtfStructureWriter {
    private static final Logger logger = LoggerFactory.getLogger(MmtfStructureWriter.class);
    private final StructureAdapterInterface mmtfDecoderInterface;

    public MmtfStructureWriter(Structure structure, StructureAdapterInterface dataTransferInterface) {
        this.mmtfDecoderInterface = dataTransferInterface;
        MmtfUtils.fixMicroheterogenity(structure);
        MmtfSummaryDataBean mmtfSummaryDataBean = MmtfUtils.getStructureInfo(structure);
        Map<String, Integer> chainIdToIndexMap = mmtfSummaryDataBean.getChainIdToIndexMap();
        List<Atom> allAtoms = mmtfSummaryDataBean.getAllAtoms();
        int numBonds = mmtfSummaryDataBean.getNumBonds();
        List<Chain> allChains = mmtfSummaryDataBean.getAllChains();
        this.mmtfDecoderInterface.initStructure(numBonds, allAtoms.size(), MmtfUtils.getNumGroups(structure), allChains.size(), structure.nrModels(), structure.getPDBCode());
        MmtfUtils.calculateDsspSecondaryStructure(structure);
        PDBHeader pdbHeader = structure.getPDBHeader();
        PDBCrystallographicInfo xtalInfo = pdbHeader.getCrystallographicInfo();
        this.mmtfDecoderInterface.setHeaderInfo(pdbHeader.getRfree(), pdbHeader.getRwork(), pdbHeader.getResolution(), pdbHeader.getTitle(), MmtfUtils.dateToIsoString(pdbHeader.getDepDate()), MmtfUtils.dateToIsoString(pdbHeader.getRelDate()), MmtfUtils.techniquesToStringArray(pdbHeader.getExperimentalTechniques()));
        this.mmtfDecoderInterface.setXtalInfo(MmtfUtils.getSpaceGroupAsString(xtalInfo.getSpaceGroup()), MmtfUtils.getUnitCellAsArray(xtalInfo), MmtfUtils.getNcsAsArray(xtalInfo.getNcsOperators()));
        this.storeBioassemblyInformation(chainIdToIndexMap, pdbHeader.getBioAssemblies());
        this.storeEntityInformation(allChains, structure.getEntityInfos());
        for (int modelIndex = 0; modelIndex < structure.nrModels(); ++modelIndex) {
            List<Chain> modelChains = structure.getChains(modelIndex);
            this.mmtfDecoderInterface.setModelInfo(modelIndex, modelChains.size());
            for (int chainInModelIndex = 0; chainInModelIndex < modelChains.size(); ++chainInModelIndex) {
                Chain chain = modelChains.get(chainInModelIndex);
                List<Group> groups = chain.getAtomGroups();
                List<Group> sequenceGroups = chain.getSeqResGroups();
                this.mmtfDecoderInterface.setChainInfo(chain.getId(), chain.getName(), groups.size());
                for (int groupInChainIndex = 0; groupInChainIndex < groups.size(); ++groupInChainIndex) {
                    Group group = groups.get(groupInChainIndex);
                    List<Atom> atomsInGroup = MmtfUtils.getAtomsForGroup(group);
                    ChemComp chemComp = group.getChemComp();
                    Character insCode = group.getResidueNumber().getInsCode();
                    if (insCode == null || insCode.equals(Character.valueOf(' '))) {
                        insCode = Character.valueOf('\u0000');
                    }
                    char singleLetterCode = 'X';
                    if (chemComp.getOne_letter_code().length() == 1) {
                        singleLetterCode = chemComp.getOne_letter_code().charAt(0);
                    }
                    this.mmtfDecoderInterface.setGroupInfo(group.getPDBName(), group.getResidueNumber().getSeqNum().intValue(), insCode.charValue(), chemComp.getType().toUpperCase(), atomsInGroup.size(), MmtfUtils.getNumBondsInGroup(atomsInGroup), singleLetterCode, sequenceGroups.indexOf(group), MmtfUtils.getSecStructType(group));
                    for (Atom atom : atomsInGroup) {
                        char altLoc = '\u0000';
                        if (atom.getAltLoc() != null && atom.getAltLoc().charValue() != ' ') {
                            altLoc = atom.getAltLoc().charValue();
                        }
                        this.mmtfDecoderInterface.setAtomInfo(atom.getName(), atom.getPDBserial(), altLoc, (float)atom.getX(), (float)atom.getY(), (float)atom.getZ(), atom.getOccupancy(), atom.getTempFactor(), atom.getElement().toString(), (int)atom.getCharge());
                        this.addBonds(atom, atomsInGroup, allAtoms);
                    }
                }
            }
        }
        this.mmtfDecoderInterface.finalizeStructure();
    }

    private void addBonds(Atom atom, List<Atom> atomsInGroup, List<Atom> allAtoms) {
        if (atom.getBonds() == null) {
            return;
        }
        for (Bond bond : atom.getBonds()) {
            int bondOrder;
            Integer secondBondIndex;
            Integer firstBondIndex;
            Atom other = bond.getOther(atom);
            if (atomsInGroup.indexOf(other) != -1) {
                firstBondIndex = atomsInGroup.indexOf(atom);
                secondBondIndex = atomsInGroup.indexOf(other);
                if (firstBondIndex <= secondBondIndex) continue;
                bondOrder = bond.getBondOrder();
                this.mmtfDecoderInterface.setGroupBond(firstBondIndex.intValue(), secondBondIndex.intValue(), bondOrder);
                continue;
            }
            firstBondIndex = allAtoms.indexOf(atom);
            secondBondIndex = allAtoms.indexOf(other);
            if (firstBondIndex <= secondBondIndex) continue;
            bondOrder = bond.getBondOrder();
            this.mmtfDecoderInterface.setInterGroupBond(firstBondIndex.intValue(), secondBondIndex.intValue(), bondOrder);
        }
    }

    private void storeEntityInformation(List<Chain> allChains, List<EntityInfo> entityInfos) {
        for (EntityInfo entityInfo : entityInfos) {
            String description = entityInfo.getDescription();
            String type = entityInfo.getType() == null ? null : entityInfo.getType().getEntityType();
            List<Chain> entityChains = entityInfo.getChains();
            if (entityChains.isEmpty()) {
                logger.error("ERROR MAPPING CHAIN TO ENTITY: " + description);
                this.mmtfDecoderInterface.setEntityInfo(new int[0], "", description, type);
                continue;
            }
            int[] chainIndices = new int[entityChains.size()];
            for (int i = 0; i < entityChains.size(); ++i) {
                chainIndices[i] = allChains.indexOf(entityChains.get(i));
            }
            Chain chain = entityChains.get(0);
            if (!(chain instanceof ChainImpl)) {
                throw new RuntimeException("Encountered Chain of unexpected type");
            }
            ChainImpl chainImpl = (ChainImpl)entityChains.get(0);
            String sequence = chainImpl.getSeqResOneLetterSeq();
            this.mmtfDecoderInterface.setEntityInfo(chainIndices, sequence, description, type);
        }
    }

    private void storeBioassemblyInformation(Map<String, Integer> chainIdToIndexMap, Map<Integer, BioAssemblyInfo> inputBioAss) {
        int bioAssemblyIndex = 0;
        for (Map.Entry<Integer, BioAssemblyInfo> entry : inputBioAss.entrySet()) {
            Map<double[], int[]> transformMap = MmtfUtils.getTransformMap(entry.getValue(), chainIdToIndexMap);
            for (Map.Entry<double[], int[]> transformEntry : transformMap.entrySet()) {
                this.mmtfDecoderInterface.setBioAssemblyTrans(bioAssemblyIndex, transformEntry.getValue(), transformEntry.getKey(), entry.getKey().toString());
            }
            ++bioAssemblyIndex;
        }
    }
}

