/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.ecod;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.SubstructureIdentifier;
import org.biojava.nbio.structure.align.util.AtomCache;

public class EcodDomain
implements Serializable,
Cloneable,
StructureIdentifier {
    private static final long serialVersionUID = -7760082165560332048L;
    private Long uid;
    private String domainId;
    private Boolean manual;
    private Integer xGroup;
    private Integer hGroup;
    private Integer tGroup;
    private Integer fGroup;
    private String pdbId;
    private String chainId;
    private String range;
    private String seqIdRange;
    private String architectureName;
    private String xGroupName;
    private String hGroupName;
    private String tGroupName;
    private String fGroupName;
    private Long assemblyId;
    private Set<String> ligands;

    public EcodDomain() {
    }

    public EcodDomain(Long uid, String domainId, Boolean manual, Integer xGroup, Integer hGroup, Integer tGroup, Integer fGroup, String pdbId, String chainId, String range, String architectureName, String xGroupName, String hGroupName, String tGroupName, String fGroupName, Long assemblyId, Set<String> ligands) {
        this(uid, domainId, manual, xGroup, hGroup, tGroup, fGroup, pdbId, chainId, range, null, architectureName, xGroupName, hGroupName, tGroupName, fGroupName, assemblyId, ligands);
    }

    public EcodDomain(Long uid, String domainId, Boolean manual, Integer xGroup, Integer hGroup, Integer tGroup, Integer fGroup, String pdbId, String chainId, String range, String seqId, String architectureName, String xGroupName, String hGroupName, String tGroupName, String fGroupName, Long assemblyId, Set<String> ligands) {
        this.uid = uid;
        this.domainId = domainId;
        this.manual = manual;
        this.xGroup = xGroup;
        this.hGroup = hGroup;
        this.tGroup = tGroup;
        this.fGroup = fGroup;
        this.pdbId = pdbId;
        this.chainId = chainId;
        this.range = range;
        this.seqIdRange = seqId;
        this.architectureName = architectureName;
        this.xGroupName = xGroupName;
        this.hGroupName = hGroupName;
        this.tGroupName = tGroupName;
        this.fGroupName = fGroupName;
        this.assemblyId = assemblyId;
        this.ligands = ligands;
    }

    public EcodDomain(String domainId) {
        this.domainId = domainId;
    }

    public EcodDomain(EcodDomain o) {
        this.uid = o.uid;
        this.domainId = o.domainId;
        this.manual = o.manual;
        this.xGroup = o.xGroup;
        this.hGroup = o.hGroup;
        this.tGroup = o.tGroup;
        this.fGroup = o.fGroup;
        this.pdbId = o.pdbId;
        this.chainId = o.chainId;
        this.range = o.range;
        this.seqIdRange = o.seqIdRange;
        this.architectureName = o.architectureName;
        this.xGroupName = o.xGroupName;
        this.hGroupName = o.hGroupName;
        this.tGroupName = o.tGroupName;
        this.fGroupName = o.fGroupName;
        this.assemblyId = o.assemblyId;
        this.ligands = new HashSet<String>(o.ligands);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new EcodDomain(this);
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public Boolean getManual() {
        return this.manual;
    }

    public void setManual(Boolean manual) {
        this.manual = manual;
    }

    public Integer getXGroup() {
        return this.xGroup;
    }

    public void setXGroup(Integer xGroup) {
        this.xGroup = xGroup;
    }

    public Integer getHGroup() {
        return this.hGroup;
    }

    public void setHGroup(Integer hGroup) {
        this.hGroup = hGroup;
    }

    public Integer getTGroup() {
        return this.tGroup;
    }

    public void setTGroup(Integer tGroup) {
        this.tGroup = tGroup;
    }

    public Integer getFGroup() {
        return this.fGroup;
    }

    public void setFGroup(Integer fGroup) {
        this.fGroup = fGroup;
    }

    public String getPdbId() {
        return this.pdbId;
    }

    public void setPdbId(String pdbId) {
        this.pdbId = pdbId;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public String getSeqIdRange() {
        return this.seqIdRange;
    }

    public void setSeqIdRange(String seqIdRange) {
        this.seqIdRange = seqIdRange;
    }

    public String getArchitectureName() {
        return this.architectureName;
    }

    public void setArchitectureName(String architectureName) {
        this.architectureName = architectureName;
    }

    public String getXGroupName() {
        return this.xGroupName;
    }

    public void setXGroupName(String xGroupName) {
        this.xGroupName = xGroupName;
    }

    public String getHGroupName() {
        return this.hGroupName;
    }

    public void setHGroupName(String hGroupName) {
        this.hGroupName = hGroupName;
    }

    public String getTGroupName() {
        return this.tGroupName;
    }

    public void setGroupName(String tGroupName) {
        this.tGroupName = tGroupName;
    }

    public String getFGroupName() {
        return this.fGroupName;
    }

    public void setFGroupName(String fGroupName) {
        this.fGroupName = fGroupName;
    }

    public Long getAssemblyId() {
        return this.assemblyId;
    }

    public void setAssemblyId(Long assemblyId) {
        this.assemblyId = assemblyId;
    }

    public Set<String> getLigands() {
        return this.ligands;
    }

    public void setLigands(Set<String> ligands) {
        this.ligands = ligands;
    }

    public String toString() {
        return "EcodDomain [uid=" + this.uid + ", domainId=" + this.domainId + ", manual=" + this.manual + ", xGroup=" + this.xGroup + ", hGroup=" + this.hGroup + ", tGroup=" + this.tGroup + ", fGroup=" + this.fGroup + ", pdbId=" + this.pdbId + ", chainName=" + this.chainId + ", range=" + this.range + ", architectureName=" + this.architectureName + ", xGroupName=" + this.xGroupName + ", hGroupName=" + this.hGroupName + ", tGroupName=" + this.tGroupName + ", fGroupName=" + this.fGroupName + ", assemblyId=" + this.assemblyId + ", ligands=" + this.ligands + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.architectureName == null ? 0 : this.architectureName.hashCode());
        result = 31 * result + (this.chainId == null ? 0 : this.chainId.hashCode());
        result = 31 * result + (this.domainId == null ? 0 : this.domainId.hashCode());
        result = 31 * result + (this.fGroupName == null ? 0 : this.fGroupName.hashCode());
        result = 31 * result + (this.fGroup == null ? 0 : this.fGroup.hashCode());
        result = 31 * result + (this.hGroup == null ? 0 : this.hGroup.hashCode());
        result = 31 * result + (this.hGroupName == null ? 0 : this.hGroupName.hashCode());
        result = 31 * result + (this.assemblyId == null ? 0 : this.assemblyId.hashCode());
        result = 31 * result + (this.ligands == null ? 0 : this.ligands.hashCode());
        result = 31 * result + (this.manual == null ? 0 : this.manual.hashCode());
        result = 31 * result + (this.pdbId == null ? 0 : this.pdbId.hashCode());
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        result = 31 * result + (this.tGroup == null ? 0 : this.tGroup.hashCode());
        result = 31 * result + (this.tGroupName == null ? 0 : this.tGroupName.hashCode());
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        result = 31 * result + (this.xGroup == null ? 0 : this.xGroup.hashCode());
        result = 31 * result + (this.xGroupName == null ? 0 : this.xGroupName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EcodDomain other = (EcodDomain)obj;
        if (this.architectureName == null ? other.architectureName != null : !this.architectureName.equals(other.architectureName)) {
            return false;
        }
        if (this.chainId == null ? other.chainId != null : !this.chainId.equals(other.chainId)) {
            return false;
        }
        if (this.domainId == null ? other.domainId != null : !this.domainId.equals(other.domainId)) {
            return false;
        }
        if (this.fGroupName == null ? other.fGroupName != null : !this.fGroupName.equals(other.fGroupName)) {
            return false;
        }
        if (this.fGroup == null ? other.fGroup != null : !this.fGroup.equals(other.fGroup)) {
            return false;
        }
        if (this.hGroup == null ? other.hGroup != null : !this.hGroup.equals(other.hGroup)) {
            return false;
        }
        if (this.hGroupName == null ? other.hGroupName != null : !this.hGroupName.equals(other.hGroupName)) {
            return false;
        }
        if (this.assemblyId == null ? other.assemblyId != null : !this.assemblyId.equals(other.assemblyId)) {
            return false;
        }
        if (this.ligands == null ? other.ligands != null : !this.ligands.equals(other.ligands)) {
            return false;
        }
        if (this.manual == null ? other.manual != null : !this.manual.equals(other.manual)) {
            return false;
        }
        if (this.pdbId == null ? other.pdbId != null : !this.pdbId.equals(other.pdbId)) {
            return false;
        }
        if (this.range == null ? other.range != null : !this.range.equals(other.range)) {
            return false;
        }
        if (this.tGroup == null ? other.tGroup != null : !this.tGroup.equals(other.tGroup)) {
            return false;
        }
        if (this.tGroupName == null ? other.tGroupName != null : !this.tGroupName.equals(other.tGroupName)) {
            return false;
        }
        if (this.uid == null ? other.uid != null : !this.uid.equals(other.uid)) {
            return false;
        }
        if (this.xGroup == null ? other.xGroup != null : !this.xGroup.equals(other.xGroup)) {
            return false;
        }
        return !(this.xGroupName == null ? other.xGroupName != null : !this.xGroupName.equals(other.xGroupName));
    }

    @Override
    public String getIdentifier() {
        return this.getDomainId();
    }

    public List<ResidueRange> getResidueRanges() {
        return ResidueRange.parseMultiple(this.range);
    }

    @Override
    public SubstructureIdentifier toCanonical() {
        return new SubstructureIdentifier(this.getPdbId(), ResidueRange.parseMultiple(this.getRange()));
    }

    @Override
    public Structure reduce(Structure input) throws StructureException {
        return this.toCanonical().reduce(input);
    }

    @Override
    public Structure loadStructure(AtomCache cache) throws StructureException, IOException {
        return cache.getStructureForPdbId(this.pdbId);
    }
}

