/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;

public class URLConnectionTools {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 30000;

    public static URLConnection openURLConnection(URL url, int timeout) throws IOException {
        URLConnection huc = url.openConnection();
        huc.setReadTimeout(timeout);
        huc.setConnectTimeout(timeout);
        return huc;
    }

    public static URLConnection openURLConnection(URL url) throws IOException {
        return URLConnectionTools.openURLConnection(url, 30000);
    }

    public static InputStream getInputStream(URL url, int timeout) throws IOException {
        return URLConnectionTools.getInputStream(url, true, timeout);
    }

    public static InputStream getInputStream(URL url) throws IOException {
        return URLConnectionTools.getInputStream(url, true, 30000);
    }

    public static InputStream getInputStream(URL url, boolean acceptGzipEncoding, int timeout) throws IOException {
        InputStream inStream = null;
        URLConnection huc = URLConnectionTools.openURLConnection(url, timeout);
        if (acceptGzipEncoding) {
            huc.setRequestProperty("Accept-Encoding", "gzip");
        }
        String contentEncoding = huc.getContentEncoding();
        inStream = huc.getInputStream();
        if (contentEncoding != null && contentEncoding.contains("gzip")) {
            inStream = new GZIPInputStream(inStream);
        }
        return inStream;
    }

    public static InputStream doPOST(URL url, String data) throws IOException {
        return URLConnectionTools.doPOST(url, data, 30000);
    }

    public static InputStream doPOST(URL url, String data, int timeout) throws IOException {
        URLConnection conn = URLConnectionTools.openURLConnection(url, timeout);
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(data);
        wr.flush();
        return conn.getInputStream();
    }
}

