/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.fatcat.calc;

import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.fatcat.calc.FCAlignHelper;
import org.biojava.nbio.structure.geometry.SuperPositions;

public class StructureAlignmentOptimizer {
    int pro1Len;
    int pro2Len;
    int maxLen;
    Atom[] cod1;
    Atom[] cod2;
    int[][] equSet;
    int equLen;
    int equLen0;
    double[][] sij;
    int maxKeepStep;
    int keepStep;
    double Dc;
    double rmsdCut;
    double increase;
    double stopLenPer;
    double stopRmsdPer;
    double stopRmsd;
    double gapIni;
    double gapExt;
    double rmsd;
    private static final boolean debug = false;

    public StructureAlignmentOptimizer(int b1, int end1, Atom[] c1, int b2, int end2, Atom[] c2, int iniLen, int[][] iniSet) throws StructureException {
        Group parent;
        Atom a;
        int i;
        int len1 = end1 - b1;
        int len2 = end2 - b2;
        this.pro1Len = len1;
        this.pro2Len = len2;
        this.cod1 = new Atom[len1];
        this.cod2 = new Atom[len2];
        for (i = 0; i < len1; ++i) {
            a = c1[i + b1];
            parent = (Group)a.getGroup().clone();
            this.cod1[i] = parent.getAtom(a.getName());
        }
        for (i = 0; i < len2; ++i) {
            a = c2[i + b2];
            parent = (Group)a.getGroup().clone();
            this.cod2[i] = parent.getAtom(a.getName());
        }
        this.maxLen = len1 < len2 ? len1 : len2;
        this.equSet = new int[2][this.maxLen];
        for (i = 0; i < iniLen; ++i) {
            this.equSet[0][i] = iniSet[0][i];
            this.equSet[1][i] = iniSet[1][i];
            if (iniSet[0][i] <= len1 && iniSet[1][i] <= len2) continue;
            throw new RuntimeException(String.format("StructureAlignmentOptimizer: focus exceeds the protein 1 or 2 length!", new Object[0]));
        }
        this.equLen0 = this.equLen = iniLen;
        this.setParameters();
        this.sij = new double[this.pro1Len][this.pro2Len];
    }

    public void runOptimization(int maxi) throws StructureException {
        this.superimposeBySet();
        this.maxKeepStep = 4;
        this.keepStep = 0;
        this.optimize(maxi);
    }

    private void setParameters() {
        this.Dc = 3.0;
        this.increase = 0.5;
        this.stopLenPer = 0.95;
        this.stopRmsdPer = 1.1;
        this.stopRmsd = -1.0;
        this.rmsdCut = 3.0;
        this.gapIni = 5.0;
        this.gapExt = 0.5;
    }

    private void superimposeBySet() throws StructureException {
        Atom[] tmp1 = new Atom[this.equLen];
        Atom[] tmp2 = new Atom[this.equLen];
        for (int i = 0; i < this.equLen; ++i) {
            int r1 = this.equSet[0][i];
            int r2 = this.equSet[1][i];
            tmp1[i] = this.cod1[r1];
            tmp2[i] = (Atom)this.cod2[r2].clone();
        }
        Matrix4d trans = SuperPositions.superpose(Calc.atomsToPoints(tmp1), Calc.atomsToPoints(tmp2));
        Calc.transform(tmp2, trans);
        this.rmsd = Calc.rmsd(tmp1, tmp2);
        Calc.transform(this.cod2, trans);
    }

    private void optimize(int maxi) throws StructureException {
        long optStart = System.currentTimeMillis();
        boolean ifstop = true;
        int alnLen = 0;
        int[][] alnList = new int[2][this.maxLen];
        for (int i = 0; i < maxi; ++i) {
            this.calMatrix();
            FCAlignHelper aln = new FCAlignHelper(this.sij, this.pro1Len, this.pro2Len, this.gapIni, this.gapExt);
            alnLen = aln.getAlignPos(alnList);
            ifstop = alnLen < 3 ? true : this.defineEquPos(alnLen, alnList);
            if (ifstop) break;
            this.Dc += this.increase;
        }
    }

    private void calMatrix() throws StructureException {
        for (int i = 0; i < this.pro1Len; ++i) {
            for (int j = 0; j < this.pro2Len; ++j) {
                double dis = Calc.getDistance(this.cod1[i], this.cod2[j]);
                this.sij[i][j] = dis < this.Dc ? this.Dc - dis : 0.0;
            }
        }
    }

    private boolean defineEquPos(int alnLen, int[][] alnList) throws StructureException {
        int i;
        int equLenOld = this.equLen;
        int[][] equSetOld = new int[2][equLenOld];
        for (i = 0; i < this.equLen; ++i) {
            equSetOld[0][i] = this.equSet[0][i];
            equSetOld[1][i] = this.equSet[1][i];
        }
        double rmsdOld = this.rmsd;
        this.equLen = 0;
        for (i = 0; i < alnLen; ++i) {
            int r1 = alnList[0][i];
            int r2 = alnList[1][i];
            double dis = Calc.getDistance(this.cod1[r1], this.cod2[r2]);
            if (!(dis <= this.Dc)) continue;
            this.equSet[0][this.equLen] = r1;
            this.equSet[1][this.equLen] = r2;
            ++this.equLen;
        }
        this.superimposeBySet();
        boolean ifstop = false;
        this.keepStep = Math.abs(this.rmsd - rmsdOld) < 1.0E-10 && equLenOld == this.equLen ? ++this.keepStep : 0;
        ifstop = this.keepStep > this.maxKeepStep ? true : (this.stopRmsd < 0.0 ? false : !(this.rmsd <= this.stopRmsd * this.stopRmsdPer) && !(this.rmsd < this.rmsdCut));
        if (this.stopRmsd < 0.0 && (double)this.equLen >= this.stopLenPer * (double)this.equLen0) {
            this.stopRmsd = this.rmsd;
        }
        return ifstop;
    }

    public double optimizeResult(int[] optLen, int optLenpos, int[][] list) {
        optLen[optLenpos] = this.equLen;
        for (int i = 0; i < this.equLen; ++i) {
            list[0][i] = this.equSet[0][i];
            list[1][i] = this.equSet[1][i];
        }
        return this.rmsd;
    }
}

