/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biojava.nbio.structure.io.mmcif.chem.PolymerType;
import org.biojava.nbio.structure.io.mmcif.chem.ResidueType;

public enum GroupType {
    AMINOACID("amino", GroupType.matchPolymerTypes(PolymerType.PROTEIN_ONLY)),
    NUCLEOTIDE("nucleotide", GroupType.matchPolymerTypes(PolymerType.POLYNUCLEOTIDE_ONLY)),
    HETATM("hetatm", GroupType.getHetatmTypes());

    private final String name;
    private final Set<ResidueType> types;
    public static final List<String> WATERNAMES;

    private GroupType(String name, Set<ResidueType> types) {
        this.name = name;
        this.types = types;
    }

    public String toString() {
        return this.name;
    }

    public Set<ResidueType> getResidueTypes() {
        return this.types;
    }

    private static Set<ResidueType> matchPolymerTypes(Set<PolymerType> allowedTypes) {
        HashSet<ResidueType> matched = new HashSet<ResidueType>();
        for (ResidueType restype : ResidueType.values()) {
            if (!allowedTypes.contains(restype.polymerType)) continue;
            matched.add(restype);
        }
        return Collections.unmodifiableSet(matched);
    }

    private static Set<ResidueType> getHetatmTypes() {
        HashSet<ResidueType> unmatched = new HashSet<ResidueType>();
        for (ResidueType restype : ResidueType.values()) {
            if (AMINOACID.getResidueTypes().contains(restype) || NUCLEOTIDE.getResidueTypes().contains(restype)) continue;
            unmatched.add(restype);
        }
        return Collections.unmodifiableSet(unmatched);
    }

    static {
        WATERNAMES = Arrays.asList("HOH", "DOD", "WAT");
    }
}

