/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.biojava.nbio.alignment.io.StockholmStructure;

public class StockholmFileAnnotation {
    private static final String TREE_DEFAULT_ID = "DEFAULT_ID";
    private static final String PB_PFAM_STRING = "PB";
    private static final String PF_PFAM_STRING = "PF";
    private static final String RF_RFAM_STRING = "RF";
    private StringBuffer format;
    private StringBuffer version;
    private String accessionNumber;
    private StringBuffer identification;
    private StringBuffer definition;
    private String[] authors;
    private String alignmentMethod;
    private CharSequence buildMethod;
    private StringBuffer searchMethod;
    private StringBuffer sourceSeed;
    private StringBuffer sourceStructure;
    private float[] gatheringThreshs;
    private float[] noiseCutoffs;
    private float[] trustedCutoffs;
    private String typeField;
    private String[] previousIDs;
    private int numSequences;
    private StringBuffer dbComment;
    private Set<StockholmStructure.DatabaseReference> dbReferences;
    private StringBuffer refComment;
    private Vector<StockholmFileAnnotationReference> references = new Vector();
    private StringBuffer keywords;
    private CharSequence comment;
    private StringBuffer pfamAccession;
    private StringBuffer location;
    private StringBuffer wikipediaLink;
    private StringBuffer clan;
    private StringBuffer membership;
    private final Map<String, List<String>> embTrees = new HashMap<String, List<String>>();
    private float falseDiscoveryRate;

    public StringBuffer getDbComment() {
        return this.dbComment;
    }

    public void setDbComment(String dbComment) {
        if (this.dbComment != null) {
            this.dbComment.append(dbComment);
        } else {
            this.dbComment = new StringBuffer(dbComment);
        }
    }

    public Set<StockholmStructure.DatabaseReference> getDbReferences() {
        return this.dbReferences;
    }

    public void setDbReferences(Set<StockholmStructure.DatabaseReference> dbReferences) {
        this.dbReferences = dbReferences;
    }

    public void addDBReference(String dbReferenceRepresentingString) {
        if (this.dbReferences == null) {
            this.dbReferences = new HashSet<StockholmStructure.DatabaseReference>();
        }
        this.dbReferences.add(new StockholmStructure.DatabaseReference(dbReferenceRepresentingString));
    }

    public float getFalseDiscoveryRate() {
        return this.falseDiscoveryRate;
    }

    public void setFalseDiscoveryRate(float falseDiscoveryRate) {
        this.falseDiscoveryRate = falseDiscoveryRate;
    }

    public StringBuffer getRefComment() {
        return this.refComment;
    }

    public StringBuffer getKeywords() {
        return this.keywords;
    }

    public String getComment() {
        return this.comment.toString();
    }

    public StringBuffer getPfamAccession() {
        return this.pfamAccession;
    }

    public StringBuffer getLocation() {
        return this.location;
    }

    public StringBuffer getWikipediaLink() {
        return this.wikipediaLink;
    }

    public StringBuffer getClan() {
        return this.clan;
    }

    public StringBuffer getMembership() {
        return this.membership;
    }

    public Map<String, List<String>> getEmbTrees() {
        return this.embTrees;
    }

    public void setNumSequences(int numSequences) {
        this.numSequences = numSequences;
    }

    public StringBuffer getIdentification() {
        return this.identification;
    }

    public void setGFIdentification(String identification) {
        if (this.identification != null) {
            this.identification.append(identification);
        } else {
            this.identification = new StringBuffer(identification);
        }
    }

    public StringBuffer getDefinition() {
        return this.definition;
    }

    public void setGFDefinition(String definition) {
        if (this.definition != null) {
            this.definition.append(definition);
        } else {
            this.definition = new StringBuffer(definition);
        }
    }

    public String[] getAuthors() {
        return this.authors;
    }

    public void setGFAuthors(String authors) {
        this.authors = authors.split(",");
    }

    public String getBuildMethod() {
        return this.buildMethod.toString();
    }

    public void addGFBuildMethod(String buildMethod) {
        if (this.buildMethod == null) {
            this.buildMethod = new StringBuffer(buildMethod);
        } else if (this.buildMethod instanceof StringBuffer) {
            ((StringBuffer)this.buildMethod).append(System.getProperty("line.seperator")).append(buildMethod);
        } else {
            this.buildMethod = new StringBuffer(this.buildMethod).append(System.getProperty("line.seperator")).append(buildMethod);
        }
    }

    public StringBuffer getSearchMethod() {
        return this.searchMethod;
    }

    public void setGFSearchMethod(String searchMethod) {
        if (this.searchMethod != null) {
            this.searchMethod.append(searchMethod);
        } else {
            this.searchMethod = new StringBuffer(searchMethod);
        }
    }

    public StringBuffer getSourceSeed() {
        return this.sourceSeed;
    }

    public void setGFSourceSeed(String sourceSeed) {
        if (this.sourceSeed != null) {
            this.sourceSeed.append(sourceSeed);
        } else {
            this.sourceSeed = new StringBuffer(sourceSeed);
        }
    }

    public StringBuffer getSourceStructure() {
        return this.sourceStructure;
    }

    public void setGFSourceStructure(String sourceStructure) {
        if (this.sourceStructure != null) {
            this.sourceStructure.append(sourceStructure);
        } else {
            this.sourceStructure = new StringBuffer(sourceStructure);
        }
    }

    public float[] getGatheringThreshs() {
        return this.gatheringThreshs;
    }

    public void setGFGatheringThreshs(String gatheringThresh) {
        this.gatheringThreshs = this.stringToFloats(gatheringThresh);
    }

    public float[] getNoiseCutoffs() {
        return this.noiseCutoffs;
    }

    public void setGFNoiseCutoffs(String noiseCutoff) {
        this.noiseCutoffs = this.stringToFloats(noiseCutoff);
    }

    public float[] getTrustedCutoffs() {
        return this.trustedCutoffs;
    }

    public void setGFTrustedCutoffs(String trustedCutoff) {
        this.trustedCutoffs = this.stringToFloats(trustedCutoff);
    }

    public float[] stringToFloats(String string) {
        String[] coublets = string.split(";");
        float[] floats = new float[coublets.length * 2];
        int counter = 0;
        for (int i = 0; i < coublets.length; ++i) {
            String[] subStrings = coublets[i].trim().split("\\s");
            float f = Float.parseFloat(subStrings[i]);
            floats[counter++] = f;
        }
        return floats;
    }

    public String getTypeField() {
        return this.typeField;
    }

    public void setGFTypeField(String typeField) {
        this.typeField = typeField;
    }

    public String[] getPreviousIDs() {
        return this.previousIDs;
    }

    public void setGFPreviousIDs(String previousIDs) {
        this.previousIDs = previousIDs.split(";");
    }

    public StringBuffer getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        if (this.format != null) {
            this.format.append(format);
        } else {
            this.format = new StringBuffer(format);
        }
    }

    public StringBuffer getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (this.version != null) {
            this.version.append(version);
        } else {
            this.version = new StringBuffer(version);
        }
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public void setGFAccessionNumber(String accessionNumber) {
        this.accessionNumber = accessionNumber;
    }

    public boolean isPFam() {
        return this.accessionNumber != null && (this.accessionNumber.startsWith(PF_PFAM_STRING) || this.accessionNumber.startsWith(PB_PFAM_STRING));
    }

    public boolean isRFam() {
        return this.accessionNumber == null || this.accessionNumber.startsWith(RF_RFAM_STRING);
    }

    public int getNumSequences() {
        return this.numSequences;
    }

    public void setGFNumSequences(String numSequences) {
        this.numSequences = Integer.parseInt(numSequences);
    }

    public void setGFDBComment(String dbComment) {
        if (this.dbComment != null) {
            this.dbComment.append(dbComment);
        } else {
            this.dbComment = new StringBuffer(dbComment);
        }
    }

    public void setGFRefComment(String refComment) {
        if (this.refComment != null) {
            this.refComment.append(refComment);
        } else {
            this.refComment = new StringBuffer(refComment);
        }
    }

    public void setGFKeywords(String keywords) {
        if (this.keywords != null) {
            this.keywords.append(keywords);
        } else {
            this.keywords = new StringBuffer(keywords);
        }
    }

    public void addToGFComment(String comment) {
        if (this.comment == null) {
            this.comment = new StringBuffer(comment);
        } else if (this.comment instanceof StringBuffer) {
            ((StringBuffer)this.comment).append(' ').append(comment);
        } else {
            this.comment = new StringBuffer(this.comment).append(' ').append(comment);
        }
    }

    public void setGFPfamAccession(String pfamAccession) {
        if (this.pfamAccession != null) {
            this.pfamAccession.append(pfamAccession);
        } else {
            this.pfamAccession = new StringBuffer(pfamAccession);
        }
    }

    public void setGFLocation(String location) {
        if (this.location != null) {
            this.location.append(location);
        } else {
            this.location = new StringBuffer(location);
        }
    }

    public void setGFWikipediaLink(String wikipediaLink) {
        if (this.wikipediaLink != null) {
            this.wikipediaLink.append(wikipediaLink);
        } else {
            this.wikipediaLink = new StringBuffer(wikipediaLink);
        }
    }

    public void setGFClan(String clan) {
        if (this.clan != null) {
            this.clan.append(clan);
        } else {
            this.clan = new StringBuffer(clan);
        }
    }

    public void setGFMembership(String membership) {
        if (this.membership != null) {
            this.membership.append(membership);
        } else {
            this.membership = new StringBuffer(membership);
        }
    }

    public void addGFNewHampshire(String newHampshire) {
        List<String> hampshireTree = this.embTrees.get(TREE_DEFAULT_ID);
        if (hampshireTree == null) {
            hampshireTree = new ArrayList<String>();
        }
        hampshireTree.add(newHampshire);
        this.embTrees.put(TREE_DEFAULT_ID, hampshireTree);
    }

    public void addGFTreeID(String treeID) {
        List<String> hampshireTree = this.embTrees.remove(TREE_DEFAULT_ID);
        this.embTrees.put(treeID, hampshireTree);
    }

    public void addGFFalseDiscoveryRate(String falseDiscoveryRate) {
        this.falseDiscoveryRate = Float.parseFloat(falseDiscoveryRate);
    }

    public String getAlignmentMethod() {
        return this.alignmentMethod;
    }

    public void setAlignmentMethod(String alignmentMethod) {
        this.alignmentMethod = alignmentMethod;
    }

    public Vector<StockholmFileAnnotationReference> getReferences() {
        return this.references;
    }

    public void setReferences(Vector<StockholmFileAnnotationReference> references) {
        this.references = references;
    }

    public static class StockholmFileAnnotationReference {
        private String refMedline;
        private CharSequence refTitle;
        private CharSequence refAuthor;
        private String refLocation;

        public String getRefMedline() {
            return this.refMedline;
        }

        public void setRefMedline(String refMedline) {
            this.refMedline = refMedline;
        }

        public String getRefTitle() {
            return this.refTitle.toString();
        }

        public void setRefTitle(String refTitle) {
            this.refTitle = refTitle;
        }

        public void addToRefTitle(String refTitle) {
            if (this.refTitle == null) {
                this.refTitle = new StringBuffer(refTitle);
            } else if (this.refTitle instanceof StringBuffer) {
                ((StringBuffer)this.refTitle).append(' ').append(refTitle);
            } else {
                this.refTitle = new StringBuffer(this.refTitle).append(' ').append(refTitle);
            }
        }

        public String getRefAuthor() {
            return this.refAuthor.toString();
        }

        public void setRefAuthor(StringBuffer refAuthor) {
            this.refAuthor = refAuthor;
        }

        public void addToRefAuthor(String refAuthor) {
            if (this.refAuthor == null) {
                this.refAuthor = new StringBuffer(refAuthor);
            } else if (this.refAuthor instanceof StringBuffer) {
                ((StringBuffer)this.refAuthor).append(' ').append(refAuthor);
            } else {
                this.refAuthor = new StringBuffer(this.refAuthor).append(' ').append(refAuthor);
            }
        }

        public String getRefLocation() {
            return this.refLocation;
        }

        public void setRefLocation(String refLocation) {
            this.refLocation = refLocation;
        }
    }
}

