/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.ast;

import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.AbstractBlock;
import org.asciidoctor.ast.AbstractNode;
import org.asciidoctor.ast.AbstractNodeImpl;
import org.asciidoctor.ast.NodeConverter;
import org.asciidoctor.internal.RubyHashUtil;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyObject;
import org.jruby.runtime.builtin.IRubyObject;

public class AbstractBlockImpl
extends AbstractNodeImpl
implements AbstractBlock {
    private static final String BLOCK_CLASS = "Block";
    private static final String SECTION_CLASS = "Section";
    protected AbstractBlock delegate;

    public AbstractBlockImpl(AbstractBlock blockDelegate, Ruby runtime) {
        super(blockDelegate, runtime);
        this.delegate = blockDelegate;
    }

    @Override
    public String title() {
        return this.getTitle();
    }

    @Override
    public String getTitle() {
        return this.delegate.getTitle();
    }

    @Override
    public String style() {
        return this.getStyle();
    }

    @Override
    public String getStyle() {
        return this.delegate.getStyle();
    }

    @Override
    public List<AbstractBlock> blocks() {
        return this.getBlocks();
    }

    @Override
    public List<AbstractBlock> getBlocks() {
        List<AbstractBlock> rubyBlocks = this.delegate.getBlocks();
        for (int i = 0; i < rubyBlocks.size(); ++i) {
            AbstractBlock abstractBlock = rubyBlocks.get(i);
            if (abstractBlock instanceof RubyArray || abstractBlock instanceof AbstractNode) continue;
            RubyObject rubyObject = (RubyObject)abstractBlock;
            rubyBlocks.set(i, (AbstractBlock)NodeConverter.createASTNode((IRubyObject)rubyObject));
        }
        return rubyBlocks;
    }

    @Override
    public Object content() {
        return this.getContent();
    }

    @Override
    public Object getContent() {
        return this.delegate.content();
    }

    @Override
    public String getNodeName() {
        return this.delegate.getNodeName();
    }

    @Override
    public String convert() {
        return this.delegate.convert();
    }

    @Override
    public int getLevel() {
        return this.delegate.getLevel();
    }

    @Override
    public AbstractBlock delegate() {
        return this.delegate;
    }

    @Override
    public List<AbstractBlock> findBy(Map<Object, Object> selector) {
        List<AbstractBlock> findBy = this.delegate.findBy((Map<Object, Object>)RubyHashUtil.convertMapToRubyHashWithSymbolsIfNecessary(this.runtime, selector));
        for (int i = 0; i < findBy.size(); ++i) {
            AbstractBlock abstractBlock = findBy.get(i);
            if (abstractBlock instanceof RubyArray || abstractBlock instanceof AbstractBlock) continue;
            RubyObject rubyObject = (RubyObject)abstractBlock;
            findBy.set(i, (AbstractBlock)NodeConverter.createASTNode((IRubyObject)rubyObject));
        }
        return findBy;
    }
}

