/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.apache.xbean.finder.archive.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarArchive
implements Archive {
    private final ClassLoader loader;
    private final URL url;

    public JarArchive(ClassLoader loader, URL url) {
        if (!"jar".equals(url.getProtocol())) {
            throw new IllegalArgumentException("not a file url: " + url);
        }
        this.loader = loader;
        this.url = url;
    }

    @Override
    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        URL resource;
        int pos = className.indexOf("<");
        if (pos > -1) {
            className = className.substring(0, pos);
        }
        if ((pos = className.indexOf(">")) > -1) {
            className = className.substring(0, pos);
        }
        if (!className.endsWith(".class")) {
            className = className.replace('.', '/') + ".class";
        }
        if ((resource = this.loader.getResource(className)) != null) {
            return resource.openStream();
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loader.loadClass(className);
    }

    @Override
    public Iterator<String> iterator() {
        try {
            return this.jar(this.url).iterator();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> jar(URL location) throws IOException {
        URL url;
        String jarPath = location.getFile();
        if (jarPath.indexOf("!") > -1) {
            jarPath = jarPath.substring(0, jarPath.indexOf("!"));
        }
        if ("file".equals((url = new URL(jarPath)).getProtocol())) {
            JarFile jarFile = new JarFile(url.getFile().replace("%20", " "));
            return this.jar(jarFile);
        }
        InputStream in = url.openStream();
        try {
            JarInputStream jarStream = new JarInputStream(in);
            List<String> list = this.jar(jarStream);
            return list;
        }
        finally {
            in.close();
        }
    }

    private List<String> jar(JarFile jarFile) {
        ArrayList<String> classNames = new ArrayList<String>();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry entry = jarEntries.nextElement();
            this.addClassName(classNames, entry);
        }
        return classNames;
    }

    private List<String> jar(JarInputStream jarStream) throws IOException {
        JarEntry entry;
        ArrayList<String> classNames = new ArrayList<String>();
        while ((entry = jarStream.getNextJarEntry()) != null) {
            this.addClassName(classNames, entry);
        }
        return classNames;
    }

    private void addClassName(List<String> classNames, JarEntry entry) {
        if (entry.isDirectory() || !entry.getName().endsWith(".class")) {
            return;
        }
        String className = entry.getName();
        if ((className = className.replaceFirst(".class$", "")).contains(".")) {
            return;
        }
        className = className.replace('/', '.');
        classNames.add(className);
    }
}

