/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.http;

import javax.servlet.http.Cookie;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.encoding.UrlEncoder;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.LongValue;

public abstract class WebResponse
extends Response {
    public static final Duration MAX_CACHE_DURATION = Duration.days((int)365);

    public abstract void addCookie(Cookie var1);

    public abstract void clearCookie(Cookie var1);

    public abstract void setHeader(String var1, String var2);

    public abstract void addHeader(String var1, String var2);

    public abstract void setDateHeader(String var1, Time var2);

    public abstract void setContentLength(long var1);

    public abstract void setContentType(String var1);

    public void setLastModifiedTime(Time time) {
        this.setDateHeader("Last-Modified", time);
    }

    public void setAttachmentHeader(String filename) {
        this.setHeader("Content-Disposition", "attachment" + this.encodeDispositionHeaderValue(filename));
    }

    public void setInlineHeader(String filename) {
        this.setHeader("Content-Disposition", "inline" + this.encodeDispositionHeaderValue(filename));
    }

    private String encodeDispositionHeaderValue(String filename) {
        return Strings.isEmpty((CharSequence)filename) ? "" : String.format("; filename=\"%1$s\"; filename*=UTF-8''%1$s", UrlEncoder.PATH_INSTANCE.encode(filename, "UTF-8"));
    }

    public abstract void setStatus(int var1);

    public abstract void sendError(int var1, String var2);

    public abstract String encodeRedirectURL(CharSequence var1);

    public abstract void sendRedirect(String var1);

    public abstract boolean isRedirect();

    public abstract void flush();

    public void disableCaching() {
        this.setDateHeader("Date", Time.now());
        this.setDateHeader("Expires", Time.START_OF_UNIX_TIME);
        this.setHeader("Pragma", "no-cache");
        this.setHeader("Cache-Control", "no-cache, no-store");
    }

    public void enableCaching(Duration duration, CacheScope scope) {
        Args.notNull((Object)duration, (String)"duration");
        Args.notNull((Object)((Object)scope), (String)"scope");
        if (duration.compareTo((LongValue)MAX_CACHE_DURATION) > 0) {
            duration = MAX_CACHE_DURATION;
        }
        Time now = Time.now();
        this.setDateHeader("Date", now);
        this.setDateHeader("Expires", now.add(duration));
        this.setHeader("Cache-Control", scope.cacheControl);
        this.addHeader("Cache-Control", "max-age=" + Math.round(duration.seconds()));
        this.setHeader("Pragma", "cache");
    }

    public static enum CacheScope {
        PUBLIC("public"),
        PRIVATE("private");

        private final String cacheControl;

        private CacheScope(String cacheControl) {
            this.cacheControl = cacheControl;
        }
    }
}

