/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention;

import com.opensymphony.xwork2.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.convention.ActionNameBuilder;

public class SEOActionNameBuilder
implements ActionNameBuilder {
    private static final Logger LOG = LogManager.getLogger(SEOActionNameBuilder.class);
    private String actionSuffix = "Action";
    private boolean lowerCase;
    private String separator;

    @Inject
    public SEOActionNameBuilder(@Inject(value="struts.convention.action.name.lowercase") String lowerCase, @Inject(value="struts.convention.action.name.separator") String separator) {
        this.lowerCase = Boolean.parseBoolean(lowerCase);
        this.separator = separator;
    }

    @Inject(value="struts.convention.action.suffix", required=false)
    public void setActionSuffix(String actionSuffix) {
        if (StringUtils.isNotBlank((CharSequence)actionSuffix)) {
            this.actionSuffix = actionSuffix;
        }
    }

    @Override
    public String build(String className) {
        String actionName = className;
        if (actionName.equals(this.actionSuffix)) {
            throw new IllegalStateException("The action name cannot be the same as the action suffix [" + this.actionSuffix + "]");
        }
        if (actionName.endsWith(this.actionSuffix)) {
            actionName = actionName.substring(0, actionName.length() - this.actionSuffix.length());
        }
        char[] ca = actionName.toCharArray();
        StringBuilder build = new StringBuilder("" + ca[0]);
        boolean lower = true;
        for (int i = 1; i < ca.length; ++i) {
            char c = ca[i];
            if (Character.isUpperCase(c) && lower) {
                build.append(this.separator);
                lower = false;
            } else if (!Character.isUpperCase(c)) {
                lower = true;
            }
            build.append(c);
        }
        actionName = build.toString();
        if (this.lowerCase) {
            actionName = actionName.toLowerCase();
        }
        LOG.trace("Changed action name from [{}] to [{}]", (Object)className, (Object)actionName);
        return actionName;
    }
}

