/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.NullsOrderType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.sql.parser.sql.common.enums.OrderDirection;
import org.apache.shardingsphere.sql.parser.sql.common.segment.SQLSegment;

public abstract class OrderByItemSegment
implements SQLSegment {
    private final int startIndex;
    private final int stopIndex;
    private final OrderDirection orderDirection;
    private final NullsOrderType nullsOrderType;

    public Optional<NullsOrderType> getNullsOrderType() {
        return Optional.ofNullable(this.nullsOrderType);
    }

    public NullsOrderType getNullsOrderType(DatabaseType databaseType) {
        if (null != this.nullsOrderType) {
            return this.nullsOrderType;
        }
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        return OrderDirection.ASC == this.orderDirection ? dialectDatabaseMetaData.getDefaultNullsOrderType() : dialectDatabaseMetaData.getDefaultNullsOrderType().getReversedOrderType();
    }

    @Generated
    public OrderByItemSegment(int startIndex, int stopIndex, OrderDirection orderDirection, NullsOrderType nullsOrderType) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.orderDirection = orderDirection;
        this.nullsOrderType = nullsOrderType;
    }

    @Override
    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }

    @Generated
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }
}

