/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl;

import com.google.common.base.Strings;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.util.ProjectionUtils;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.mysql.type.MySQLDatabaseType;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ColumnProjection
implements Projection {
    private final IdentifierValue owner;
    private final IdentifierValue name;
    private final IdentifierValue alias;
    private final DatabaseType databaseType;
    private IdentifierValue originalTable;
    private IdentifierValue originalColumn;

    public ColumnProjection(String owner, String name, String alias, DatabaseType databaseType) {
        this(null == owner ? null : new IdentifierValue(owner, QuoteCharacter.NONE), new IdentifierValue(name, QuoteCharacter.NONE), null == alias ? null : new IdentifierValue(alias, QuoteCharacter.NONE), databaseType);
    }

    @Override
    public String getColumnName() {
        return this.databaseType instanceof MySQLDatabaseType ? ProjectionUtils.getColumnNameFromColumn(this.name, this.databaseType) : this.getColumnLabel();
    }

    @Override
    public String getColumnLabel() {
        return this.getAlias().isPresent() ? ProjectionUtils.getColumnLabelFromAlias(this.getAlias().get(), this.databaseType) : ProjectionUtils.getColumnNameFromColumn(this.name, this.databaseType);
    }

    @Override
    public String getExpression() {
        return null == this.owner ? this.name.getValue() : this.owner.getValue() + "." + this.name.getValue();
    }

    @Override
    public Optional<IdentifierValue> getAlias() {
        return Optional.ofNullable(this.alias);
    }

    public Optional<IdentifierValue> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public IdentifierValue getOriginalTable() {
        if (null == this.originalTable || Strings.isNullOrEmpty((String)this.originalTable.getValue())) {
            return null == this.owner ? new IdentifierValue("") : this.owner;
        }
        return this.originalTable;
    }

    public IdentifierValue getOriginalColumn() {
        return null == this.originalColumn || Strings.isNullOrEmpty((String)this.originalColumn.getValue()) ? this.name : this.originalColumn;
    }

    @Generated
    public ColumnProjection(IdentifierValue owner, IdentifierValue name, IdentifierValue alias, DatabaseType databaseType) {
        this.owner = owner;
        this.name = name;
        this.alias = alias;
        this.databaseType = databaseType;
    }

    @Generated
    public IdentifierValue getName() {
        return this.name;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public void setOriginalTable(IdentifierValue originalTable) {
        this.originalTable = originalTable;
    }

    @Generated
    public void setOriginalColumn(IdentifierValue originalColumn) {
        this.originalColumn = originalColumn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnProjection)) {
            return false;
        }
        ColumnProjection other = (ColumnProjection)o;
        Optional<IdentifierValue> this$owner = this.getOwner();
        Optional<IdentifierValue> other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        IdentifierValue this$name = this.getName();
        IdentifierValue other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<IdentifierValue> this$alias = this.getAlias();
        Optional<IdentifierValue> other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !((Object)this$alias).equals(other$alias)) {
            return false;
        }
        DatabaseType this$databaseType = this.getDatabaseType();
        DatabaseType other$databaseType = other.getDatabaseType();
        return !(this$databaseType == null ? other$databaseType != null : !this$databaseType.equals(other$databaseType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<IdentifierValue> $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        IdentifierValue $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<IdentifierValue> $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : ((Object)$alias).hashCode());
        DatabaseType $databaseType = this.getDatabaseType();
        result = result * 59 + ($databaseType == null ? 43 : $databaseType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ColumnProjection(owner=" + this.getOwner() + ", name=" + this.getName() + ", alias=" + this.getAlias() + ", databaseType=" + this.getDatabaseType() + ", originalTable=" + this.getOriginalTable() + ", originalColumn=" + this.getOriginalColumn() + ")";
    }
}

