/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.plain;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.acl.plain.PlainAccessResource;
import org.apache.rocketmq.acl.plain.RemoteAddressStrategy;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;

public class RemoteAddressStrategyFactory {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqCommon");
    public static final NullRemoteAddressStrategy NULL_NET_ADDRESS_STRATEGY = new NullRemoteAddressStrategy();
    public static final BlankRemoteAddressStrategy BLANK_NET_ADDRESS_STRATEGY = new BlankRemoteAddressStrategy();

    public RemoteAddressStrategy getRemoteAddressStrategy(PlainAccessResource plainAccessResource) {
        return this.getRemoteAddressStrategy(plainAccessResource.getWhiteRemoteAddress());
    }

    public RemoteAddressStrategy getRemoteAddressStrategy(String remoteAddr) {
        if (StringUtils.isBlank((CharSequence)remoteAddr)) {
            return BLANK_NET_ADDRESS_STRATEGY;
        }
        if ("*".equals(remoteAddr)) {
            return NULL_NET_ADDRESS_STRATEGY;
        }
        if (remoteAddr.endsWith("}")) {
            String[] strArray = StringUtils.split((String)remoteAddr, (String)".");
            String four = strArray[3];
            if (!four.startsWith("{")) {
                throw new AclException(String.format("MultipleRemoteAddressStrategy netaddress examine scope Exception netaddress", remoteAddr));
            }
            return new MultipleRemoteAddressStrategy(AclUtils.getAddreeStrArray(remoteAddr, four));
        }
        if (AclUtils.isColon(remoteAddr)) {
            return new MultipleRemoteAddressStrategy(StringUtils.split((String)remoteAddr, (String)","));
        }
        if (AclUtils.isAsterisk(remoteAddr) || AclUtils.isMinus(remoteAddr)) {
            return new RangeRemoteAddressStrategy(remoteAddr);
        }
        return new OneRemoteAddressStrategy(remoteAddr);
    }

    public static class RangeRemoteAddressStrategy
    implements RemoteAddressStrategy {
        private String head;
        private int start;
        private int end;
        private int index;

        public RangeRemoteAddressStrategy(String remoteAddr) {
            String[] strArray = StringUtils.split((String)remoteAddr, (String)".");
            if (this.analysis(strArray, 2) || this.analysis(strArray, 3)) {
                AclUtils.verify(remoteAddr, this.index - 1);
                StringBuffer sb = new StringBuffer().append(strArray[0].trim()).append(".").append(strArray[1].trim()).append(".");
                if (this.index == 3) {
                    sb.append(strArray[2].trim()).append(".");
                }
                this.head = sb.toString();
            }
        }

        private boolean analysis(String[] strArray, int index) {
            String value = strArray[index].trim();
            this.index = index;
            if ("*".equals(value)) {
                this.setValue(0, 255);
            } else if (AclUtils.isMinus(value)) {
                if (value.indexOf("-") == 0) {
                    throw new AclException(String.format("RangeRemoteAddressStrategy netaddress examine scope Exception value %s ", value));
                }
                String[] valueArray = StringUtils.split((String)value, (String)"-");
                this.start = Integer.valueOf(valueArray[0]);
                this.end = Integer.valueOf(valueArray[1]);
                if (!AclUtils.isScope(this.end) || !AclUtils.isScope(this.start) || this.start > this.end) {
                    throw new AclException(String.format("RangeRemoteAddressStrategy netaddress examine scope Exception start is %s , end is %s", this.start, this.end));
                }
            }
            return this.end > 0;
        }

        private void setValue(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public boolean match(PlainAccessResource plainAccessResource) {
            String value;
            Integer address;
            String netAddress = plainAccessResource.getWhiteRemoteAddress();
            return netAddress.startsWith(this.head) && (address = Integer.valueOf(value = this.index == 3 ? netAddress.substring(this.head.length()) : netAddress.substring(this.head.length(), netAddress.lastIndexOf(46)))) >= this.start && address <= this.end;
        }
    }

    public static class OneRemoteAddressStrategy
    implements RemoteAddressStrategy {
        private String netaddress;

        public OneRemoteAddressStrategy(String netaddress) {
            this.netaddress = netaddress;
            AclUtils.verify(netaddress, 4);
        }

        @Override
        public boolean match(PlainAccessResource plainAccessResource) {
            return this.netaddress.equals(plainAccessResource.getWhiteRemoteAddress());
        }
    }

    public static class MultipleRemoteAddressStrategy
    implements RemoteAddressStrategy {
        private final Set<String> multipleSet = new HashSet<String>();

        public MultipleRemoteAddressStrategy(String[] strArray) {
            for (String netaddress : strArray) {
                AclUtils.verify(netaddress, 4);
                this.multipleSet.add(netaddress);
            }
        }

        @Override
        public boolean match(PlainAccessResource plainAccessResource) {
            return this.multipleSet.contains(plainAccessResource.getWhiteRemoteAddress());
        }
    }

    public static class BlankRemoteAddressStrategy
    implements RemoteAddressStrategy {
        @Override
        public boolean match(PlainAccessResource plainAccessResource) {
            return false;
        }
    }

    public static class NullRemoteAddressStrategy
    implements RemoteAddressStrategy {
        @Override
        public boolean match(PlainAccessResource plainAccessResource) {
            return true;
        }
    }
}

