/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.plain;

import java.util.Map;
import java.util.TreeMap;
import org.apache.rocketmq.acl.AccessResource;
import org.apache.rocketmq.acl.AccessValidator;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.acl.plain.PlainAccessResource;
import org.apache.rocketmq.acl.plain.PlainPermissionLoader;
import org.apache.rocketmq.common.protocol.header.GetConsumerListByGroupRequestHeader;
import org.apache.rocketmq.common.protocol.header.UnregisterClientRequestHeader;
import org.apache.rocketmq.common.protocol.header.UpdateConsumerOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.heartbeat.ConsumerData;
import org.apache.rocketmq.common.protocol.heartbeat.HeartbeatData;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class PlainAccessValidator
implements AccessValidator {
    private PlainPermissionLoader aclPlugEngine = new PlainPermissionLoader();

    @Override
    public AccessResource parse(RemotingCommand request, String remoteAddr) {
        PlainAccessResource accessResource = new PlainAccessResource();
        if (remoteAddr != null && remoteAddr.contains(":")) {
            accessResource.setWhiteRemoteAddress(remoteAddr.split(":")[0]);
        } else {
            accessResource.setWhiteRemoteAddress(remoteAddr);
        }
        accessResource.setRequestCode(request.getCode());
        if (request.getExtFields() == null) {
            return accessResource;
        }
        accessResource.setAccessKey((String)request.getExtFields().get("AccessKey"));
        accessResource.setSignature((String)request.getExtFields().get("Signature"));
        accessResource.setSecretToken((String)request.getExtFields().get("SecurityToken"));
        try {
            switch (request.getCode()) {
                case 10: {
                    accessResource.addResourceAndPerm((String)request.getExtFields().get("topic"), (byte)4);
                    break;
                }
                case 310: {
                    accessResource.addResourceAndPerm((String)request.getExtFields().get("b"), (byte)4);
                    break;
                }
                case 36: {
                    accessResource.addResourceAndPerm((String)request.getExtFields().get("originTopic"), (byte)4);
                    accessResource.addResourceAndPerm(PlainAccessResource.getRetryTopic((String)request.getExtFields().get("group")), (byte)8);
                    break;
                }
                case 11: {
                    accessResource.addResourceAndPerm((String)request.getExtFields().get("topic"), (byte)8);
                    accessResource.addResourceAndPerm(PlainAccessResource.getRetryTopic((String)request.getExtFields().get("consumerGroup")), (byte)8);
                    break;
                }
                case 12: {
                    accessResource.addResourceAndPerm((String)request.getExtFields().get("topic"), (byte)8);
                    break;
                }
                case 34: {
                    HeartbeatData heartbeatData = (HeartbeatData)HeartbeatData.decode((byte[])request.getBody(), HeartbeatData.class);
                    for (ConsumerData consumerData : heartbeatData.getConsumerDataSet()) {
                        accessResource.addResourceAndPerm(PlainAccessResource.getRetryTopic(consumerData.getGroupName()), (byte)8);
                        for (SubscriptionData subscriptionData : consumerData.getSubscriptionDataSet()) {
                            accessResource.addResourceAndPerm(subscriptionData.getTopic(), (byte)8);
                        }
                    }
                    break;
                }
                case 35: {
                    UnregisterClientRequestHeader unregisterClientRequestHeader = (UnregisterClientRequestHeader)request.decodeCommandCustomHeader(UnregisterClientRequestHeader.class);
                    accessResource.addResourceAndPerm(PlainAccessResource.getRetryTopic(unregisterClientRequestHeader.getConsumerGroup()), (byte)8);
                    break;
                }
                case 38: {
                    GetConsumerListByGroupRequestHeader getConsumerListByGroupRequestHeader = (GetConsumerListByGroupRequestHeader)request.decodeCommandCustomHeader(GetConsumerListByGroupRequestHeader.class);
                    accessResource.addResourceAndPerm(PlainAccessResource.getRetryTopic(getConsumerListByGroupRequestHeader.getConsumerGroup()), (byte)8);
                    break;
                }
                case 15: {
                    UpdateConsumerOffsetRequestHeader updateConsumerOffsetRequestHeader = (UpdateConsumerOffsetRequestHeader)request.decodeCommandCustomHeader(UpdateConsumerOffsetRequestHeader.class);
                    accessResource.addResourceAndPerm(PlainAccessResource.getRetryTopic(updateConsumerOffsetRequestHeader.getConsumerGroup()), (byte)8);
                    accessResource.addResourceAndPerm(updateConsumerOffsetRequestHeader.getTopic(), (byte)8);
                    break;
                }
            }
        }
        catch (Throwable t) {
            throw new AclException(t.getMessage(), t);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Map.Entry entry : request.getExtFields().entrySet()) {
            if ("Signature".equals(entry.getKey())) continue;
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        accessResource.setContent(AclUtils.combineRequestContent(request, map));
        return accessResource;
    }

    @Override
    public void validate(AccessResource accessResource) {
        this.aclPlugEngine.validate((PlainAccessResource)accessResource);
    }
}

