/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.moses;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.moses.MosesSentenceSampleStream;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

public class MosesSentenceSampleStreamFactory<P>
extends AbstractSampleStreamFactory<SentenceSample, P> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(SentenceSample.class, "moses", new MosesSentenceSampleStreamFactory<Parameters>(Parameters.class));
    }

    protected MosesSentenceSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<SentenceSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        CmdLineUtil.checkInputFile("Data", params.getData());
        InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory(params.getData());
        PlainTextByLineStream lineStream = null;
        try {
            lineStream = new PlainTextByLineStream(sampleDataIn, params.getEncoding());
        }
        catch (IOException ex) {
            CmdLineUtil.handleCreateObjectStreamError(ex);
        }
        return new MosesSentenceSampleStream(lineStream);
    }

    static interface Parameters
    extends BasicFormatParams {
    }
}

