/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.maxent.GIS;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.model.AbstractModel;
import opennlp.model.Event;
import opennlp.model.EventStream;
import opennlp.model.MaxentModel;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.DiscourseModel;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.resolver.AbstractResolver;
import opennlp.tools.coref.resolver.DefaultNonReferentialResolver;
import opennlp.tools.coref.resolver.FixedNonReferentialResolver;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;
import opennlp.tools.coref.resolver.ResolverUtils;
import opennlp.tools.coref.sim.TestSimilarityModel;
import opennlp.tools.util.CollectionEventStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MaxentResolver
extends AbstractResolver {
    public static final String SAME = "same";
    public static final String DIFF = "diff";
    public static final String DEFAULT = "default";
    private static boolean debugOn = false;
    private String modelName;
    private MaxentModel model;
    private double[] candProbs;
    private int sameIndex;
    private ResolverMode mode;
    private List<Event> events;
    protected boolean preferFirstReferent;
    protected boolean pairedSampleSelection;
    protected boolean useSameModelForNonRef;
    private static TestSimilarityModel simModel = null;
    protected NonReferentialResolver nonReferentialResolver;
    private static final String modelExtension = ".bin.gz";

    protected MaxentResolver(int numberOfEntitiesBack, boolean preferFirstReferent) {
        super(numberOfEntitiesBack);
        this.preferFirstReferent = preferFirstReferent;
    }

    public MaxentResolver(String modelDirectory, String name, ResolverMode mode, int numberOfEntitiesBack, boolean preferFirstReferent, NonReferentialResolver nonReferentialResolver) throws IOException {
        super(numberOfEntitiesBack);
        this.preferFirstReferent = preferFirstReferent;
        this.nonReferentialResolver = nonReferentialResolver;
        this.mode = mode;
        this.modelName = modelDirectory + "/" + name;
        if (ResolverMode.TEST == this.mode) {
            this.model = new SuffixSensitiveGISModelReader(new File(this.modelName + modelExtension)).getModel();
            this.sameIndex = this.model.getIndex(SAME);
        } else if (ResolverMode.TRAIN == this.mode) {
            this.events = new ArrayList<Event>();
        } else {
            System.err.println("Unknown mode: " + (Object)((Object)this.mode));
        }
        this.candProbs = new double[this.getNumEntities() + 1];
    }

    public MaxentResolver(String modelDirectory, String modelName, ResolverMode mode, int numberEntitiesBack) throws IOException {
        this(modelDirectory, modelName, mode, numberEntitiesBack, false);
    }

    public MaxentResolver(String modelDirectory, String modelName, ResolverMode mode, int numberEntitiesBack, NonReferentialResolver nonReferentialResolver) throws IOException {
        this(modelDirectory, modelName, mode, numberEntitiesBack, false, nonReferentialResolver);
    }

    public MaxentResolver(String modelDirectory, String modelName, ResolverMode mode, int numberEntitiesBack, boolean preferFirstReferent) throws IOException {
        this(modelDirectory, modelName, mode, numberEntitiesBack, preferFirstReferent, new DefaultNonReferentialResolver(modelDirectory, modelName, mode));
    }

    public MaxentResolver(String modelDirectory, String modelName, ResolverMode mode, int numberEntitiesBack, boolean preferFirstReferent, double nonReferentialProbability) throws IOException {
        this(modelDirectory, modelName, mode, numberEntitiesBack, preferFirstReferent, new FixedNonReferentialResolver(nonReferentialProbability));
    }

    @Override
    public DiscourseEntity resolve(MentionContext ec, DiscourseModel dm) {
        DiscourseEntity de;
        int ei = 0;
        double nonReferentialProbability = this.nonReferentialResolver.getNonReferentialProbability(ec);
        if (debugOn) {
            System.err.println(this + ".resolve: " + ec.toText() + " -> " + "null " + nonReferentialProbability);
        }
        while (ei < this.getNumEntities(dm) && !this.outOfRange(ec, de = dm.getEntity(ei))) {
            if (this.excluded(ec, de)) {
                this.candProbs[ei] = 0.0;
                if (debugOn) {
                    System.err.println("excluded " + this + ".resolve: " + ec.toText() + " -> " + de + " " + this.candProbs[ei]);
                }
            } else {
                List<String> lfeatures = this.getFeatures(ec, de);
                String[] features = lfeatures.toArray(new String[lfeatures.size()]);
                try {
                    this.candProbs[ei] = this.model.eval(features)[this.sameIndex];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.candProbs[ei] = 0.0;
                }
                if (debugOn) {
                    System.err.println(this + ".resolve: " + ec.toText() + " -> " + de + " (" + ec.getGender() + "," + de.getGender() + ") " + this.candProbs[ei] + " " + lfeatures);
                }
            }
            if (this.preferFirstReferent && this.candProbs[ei] > nonReferentialProbability) {
                ++ei;
                break;
            }
            ++ei;
        }
        this.candProbs[ei] = nonReferentialProbability;
        int maxCandIndex = 0;
        for (int k = 1; k <= ei; ++k) {
            if (!(this.candProbs[k] > this.candProbs[maxCandIndex])) continue;
            maxCandIndex = k;
        }
        if (maxCandIndex == ei) {
            return null;
        }
        de = dm.getEntity(maxCandIndex);
        return de;
    }

    protected boolean defaultReferent(DiscourseEntity de) {
        MentionContext ec = de.getLastExtent();
        return ec.getNounPhraseSentenceIndex() == 0;
    }

    @Override
    public DiscourseEntity retain(MentionContext mention, DiscourseModel dm) {
        if (ResolverMode.TRAIN == this.mode) {
            DiscourseEntity de = null;
            boolean referentFound = false;
            boolean hasReferentialCandidate = false;
            boolean nonReferentFound = false;
            for (int ei = 0; ei < this.getNumEntities(dm); ++ei) {
                DiscourseEntity cde = dm.getEntity(ei);
                MentionContext entityMention = cde.getLastExtent();
                if (this.outOfRange(mention, cde)) {
                    if (mention.getId() == -1 || referentFound) break;
                    break;
                }
                if (this.excluded(mention, cde)) {
                    if (this.showExclusions && mention.getId() != -1 && entityMention.getId() == mention.getId()) {
                        System.err.println(this + ".retain: Referent excluded: (" + mention.getId() + ") " + mention.toText() + " " + mention.getIndexSpan() + " -> (" + entityMention.getId() + ") " + entityMention.toText() + " " + entityMention.getSpan() + " " + this);
                    }
                } else {
                    hasReferentialCandidate = true;
                    boolean useAsDifferentExample = this.defaultReferent(cde);
                    List<String> features = this.getFeatures(mention, cde);
                    if (debugOn) {
                        System.err.println(this + ".retain: " + mention.getId() + " " + mention.toText() + " -> " + entityMention.getId() + " " + cde);
                    }
                    if (mention.getId() != -1 && entityMention.getId() == mention.getId()) {
                        referentFound = true;
                        this.events.add(new Event(SAME, features.toArray(new String[features.size()])));
                        de = cde;
                        this.distances.add(ei);
                    } else if (!this.pairedSampleSelection || !nonReferentFound && useAsDifferentExample) {
                        nonReferentFound = true;
                        this.events.add(new Event(DIFF, features.toArray(new String[features.size()])));
                    }
                }
                if (this.pairedSampleSelection && referentFound && nonReferentFound || this.preferFirstReferent && referentFound) break;
            }
            if (hasReferentialCandidate) {
                this.nonReferentialResolver.addEvent(mention);
            }
            return de;
        }
        return super.retain(mention, dm);
    }

    protected List<String> getFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList<String> features = new ArrayList<String>();
        features.add(DEFAULT);
        features.addAll(ResolverUtils.getCompatibilityFeatures(mention, entity, simModel));
        return features;
    }

    @Override
    public void train() throws IOException {
        if (ResolverMode.TRAIN == this.mode) {
            if (debugOn) {
                System.err.println(this + " referential");
                FileWriter writer = new FileWriter(this.modelName + ".events");
                for (Event e : this.events) {
                    writer.write(e.toString() + "\n");
                }
                writer.close();
            }
            new SuffixSensitiveGISModelWriter((AbstractModel)GIS.trainModel((EventStream)new CollectionEventStream(this.events), (int)100, (int)10), new File(this.modelName + modelExtension)).persist();
            this.nonReferentialResolver.train();
        }
    }

    public static void setSimilarityModel(TestSimilarityModel sm) {
        simModel = sm;
    }

    @Override
    protected boolean excluded(MentionContext ec, DiscourseEntity de) {
        return super.excluded(ec, de);
    }
}

