/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.LockModeType;
import org.apache.openjpa.kernel.AbstractHintHandler;
import org.apache.openjpa.kernel.FetchConfigurationImpl;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.persistence.FetchPlanImpl;
import org.apache.openjpa.persistence.MixedLockLevelsHelper;
import org.apache.openjpa.persistence.PersistenceExceptions;

public class FetchPlanHintHandler
extends AbstractHintHandler {
    private static final Localizer _loc;
    protected static final String PREFIX_JPA = "javax.persistence.";
    protected static final String PREFIX_FETCHPLAN = "openjpa.FetchPlan.";
    protected static final Set<String> ValidProductPrefixes;
    protected static final Map<String, String> JavaxHintsMap;
    protected static final Map<String, String[]> PrecedenceMap;
    protected FetchPlanImpl _fPlan;

    public FetchPlanHintHandler(FetchPlanImpl fetchPlan) {
        super((FetchConfigurationImpl)fetchPlan.getDelegate());
        this._fPlan = fetchPlan;
    }

    public boolean setHint(String hintName, Object value, boolean validateThrowException) {
        if (!hintName.startsWith(PREFIX_JPA) && !ValidProductPrefixes.contains(FetchPlanHintHandler.getPrefixOf(hintName))) {
            return false;
        }
        return super.setHint(hintName, value, validateThrowException);
    }

    protected boolean setHintInternal(String hintName, Object value, boolean validateThrowException) {
        boolean valueSet = false;
        if (hintName.startsWith(PREFIX_FETCHPLAN)) {
            if (hintName.endsWith("LockMode") && !this._fConfig.getContext().isActive()) {
                this._fConfig.setHint(hintName + ".Defer", this.toLockLevel(value), false);
                valueSet = true;
            } else {
                valueSet = this.hintToSetter(this._fPlan, hintName, value);
            }
        } else {
            this._fConfig.setHint(hintName, value, validateThrowException);
        }
        return valueSet;
    }

    protected String hintToKey(String key) {
        if (!key.startsWith("openjpa.") && ValidProductPrefixes.contains(FetchPlanHintHandler.getPrefixOf(key))) {
            key = "openjpa." + key.substring(key.indexOf(46) + 1);
        }
        if (JavaxHintsMap.containsKey(key)) {
            key = JavaxHintsMap.get(key);
        }
        return key;
    }

    protected boolean hasPrecedent(String key) {
        boolean hasPrecedent = true;
        String[] list = PrecedenceMap.get(key);
        if (list != null) {
            for (String hint : list) {
                if (hint.equals(key)) break;
                if (this._fConfig.getHint(hint) == null) continue;
                hasPrecedent = false;
                break;
            }
        }
        return hasPrecedent;
    }

    protected void handleException(RuntimeException e) {
        throw PersistenceExceptions.toPersistenceException(e);
    }

    private Integer toLockLevel(Object value) {
        Object origValue = value;
        if (value instanceof String) {
            String strValue = ((String)value).toUpperCase().replace('-', '_');
            value = Enum.valueOf(LockModeType.class, strValue);
        }
        if (value instanceof LockModeType) {
            value = MixedLockLevelsHelper.toLockLevel((LockModeType)((Object)value));
        }
        Integer intValue = null;
        if (value instanceof Integer) {
            intValue = (Integer)value;
        }
        if (intValue == null || intValue != 0 && intValue != 10 && intValue != 15 && intValue != 20 && intValue != 25 && intValue != 30 && intValue != 40 && intValue != 50) {
            throw new IllegalArgumentException(_loc.get("bad-lock-level", origValue).getMessage());
        }
        return intValue;
    }

    static {
        String[][] precedenceMapList;
        _loc = Localizer.forPackage(FetchPlanHintHandler.class);
        ValidProductPrefixes = new HashSet<String>();
        JavaxHintsMap = new HashMap<String, String>();
        PrecedenceMap = new HashMap<String, String[]>();
        for (String prefix : ProductDerivations.getConfigurationPrefixes()) {
            ValidProductPrefixes.add(prefix);
        }
        JavaxHintsMap.put("javax.persistence.lock.timeout", "openjpa.FetchPlan.LockTimeout");
        JavaxHintsMap.put("javax.persistence.query.timeout", "openjpa.FetchPlan.QueryTimeout");
        String[][] arr$ = precedenceMapList = new String[][]{{"javax.persistence.lock.timeout", "openjpa.FetchPlan.LockTimeout", "openjpa.LockTimeout"}, {"javax.persistence.query.timeout", "openjpa.FetchPlan.QueryTimeout", "openjpa.QueryTimeout"}, {"openjpa.FetchPlan.Isolation", "openjpa.jdbc.TransactionIsolation"}, {"openjpa.FetchPlan.EagerFetchMode", "openjpa.jdbc.EagerFetchMode"}, {"openjpa.FetchPlan.FetchDirection", "openjpa.jdbc.FetchDirection"}, {"openjpa.FetchPlan.JoinSyntax", "openjpa.jdbc.JoinSyntax"}, {"openjpa.FetchPlan.LRSSizeAlgorithm", "openjpa.FetchPlan.LRSSize", "openjpa.jdbc.LRSSize"}, {"openjpa.FetchPlan.ResultSetType", "openjpa.jdbc.ResultSetType"}, {"openjpa.FetchPlan.SubclassFetchMode", "openjpa.jdbc.SubclassFetchMode"}, {"openjpa.FetchPlan.ReadLockMode", "openjpa.ReadLockLevel"}, {"openjpa.FetchPlan.WriteLockMode", "openjpa.WriteLockLevel"}, {"openjpa.FetchPlan.FetchBatchSize", "openjpa.FetchBatchSize"}, {"openjpa.FetchPlan.MaxFetchDepth", "openjpa.MaxFetchDepth"}};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] list;
            for (String hint : list = arr$[i$]) {
                PrecedenceMap.put(hint, list);
            }
        }
    }
}

