/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.jdbc.meta.strats.ColumnVersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import serp.util.Numbers;

public class NumberVersionStrategy
extends ColumnVersionStrategy {
    public static final String ALIAS = "version-number";
    private Number _initial = Numbers.valueOf(1);

    public void setInitialValue(int initial) {
        this._initial = Numbers.valueOf(initial);
    }

    public int getInitialValue() {
        return this._initial.intValue();
    }

    public String getAlias() {
        return ALIAS;
    }

    protected int getJavaType() {
        return 5;
    }

    protected Object nextVersion(Object version) {
        if (version == null) {
            return this._initial;
        }
        return Numbers.valueOf(((Number)version).intValue() + 1);
    }

    public Map getBulkUpdateValues() {
        Column[] cols = this.vers.getColumns();
        HashMap<Column, String> map = new HashMap<Column, String>(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            map.put(cols[i], cols[i].getName() + " + 1");
        }
        return map;
    }
}

