/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.ConnectionInfo;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCLockManager;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.VersionLockManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.LockException;

public class PessimisticLockManager
extends VersionLockManager
implements JDBCLockManager {
    public static final int LOCK_DATASTORE_ONLY = 1;
    private static final Localizer _loc = Localizer.forPackage(PessimisticLockManager.class);
    private JDBCStore _store;

    public PessimisticLockManager() {
        this.setVersionCheckOnReadLock(false);
        this.setVersionUpdateOnWriteLock(false);
    }

    public void setContext(StoreContext ctx) {
        super.setContext(ctx);
        this._store = (JDBCStore)((Object)ctx.getStoreManager().getInnermostDelegate());
    }

    public boolean selectForUpdate(Select sel, int lockLevel) {
        if (lockLevel == 0) {
            return false;
        }
        DBDictionary dict = this._store.getDBDictionary();
        if (dict.simulateLocking) {
            return false;
        }
        dict.assertSupport(dict.supportsSelectForUpdate, "SupportsSelectForUpdate");
        if (!sel.supportsLocking()) {
            if (this.log.isInfoEnabled()) {
                this.log.info(_loc.get("cant-lock-on-load", sel.toSelect(false, null).getSQL()));
            }
            return false;
        }
        this.ensureStoreManagerTransaction();
        return true;
    }

    public void loadedForUpdate(OpenJPAStateManager sm) {
        if (this.getLockLevel(sm) == 0) {
            this.setLockLevel(sm, 1);
        }
    }

    protected void lockInternal(OpenJPAStateManager sm, int level, int timeout, Object sdata, boolean postVersionCheck) {
        ConnectionInfo info;
        if (!(this.getLockLevel(sm) != 0 || (info = (ConnectionInfo)sdata) != null && info.result != null && info.result.isLocking())) {
            this.lockRow(sm, timeout, level);
        }
        this.optimisticLockInternal(sm, level, timeout, sdata, postVersionCheck);
    }

    private void lockRow(OpenJPAStateManager sm, int timeout, int level) {
        DBDictionary dict = this._store.getDBDictionary();
        JDBCFetchConfiguration fetch = this._store.getFetchConfiguration();
        if (dict.simulateLocking) {
            return;
        }
        dict.assertSupport(dict.supportsSelectForUpdate, "SupportsSelectForUpdate");
        Object id = sm.getObjectId();
        ClassMapping mapping = (ClassMapping)sm.getMetaData();
        while (mapping.getJoinablePCSuperclassMapping() != null) {
            mapping = mapping.getJoinablePCSuperclassMapping();
        }
        Select select = this._store.getSQLFactory().newSelect();
        select.select(mapping.getPrimaryKeyColumns());
        select.wherePrimaryKey(id, mapping, this._store);
        SQLBuffer sql2 = select.toSelect(true, fetch);
        this.ensureStoreManagerTransaction();
        Connection conn = this._store.getConnection();
        PreparedStatement stmnt = null;
        ResultSet rs = null;
        try {
            stmnt = this.prepareStatement(conn, sql2);
            dict.setTimeouts(stmnt, fetch, true);
            rs = this.executeQuery(conn, stmnt, sql2);
            this.checkLock(rs, sm, timeout);
        }
        catch (SQLException se) {
            throw SQLExceptions.getStoreSQLException(sm, se, dict, level);
        }
        finally {
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException se) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {}
            }
            try {
                conn.close();
            }
            catch (SQLException se) {}
        }
    }

    private void ensureStoreManagerTransaction() {
        if (!this._store.getContext().isStoreActive()) {
            this._store.getContext().beginStore();
            if (this.log.isInfoEnabled()) {
                this.log.info(_loc.get("start-trans-for-lock"));
            }
        }
    }

    public JDBCStore getStore() {
        return this._store;
    }

    protected PreparedStatement prepareStatement(Connection conn, SQLBuffer sql2) throws SQLException {
        return sql2.prepareStatement(conn);
    }

    protected ResultSet executeQuery(Connection conn, PreparedStatement stmnt, SQLBuffer sql2) throws SQLException {
        return stmnt.executeQuery();
    }

    protected void checkLock(ResultSet rs, OpenJPAStateManager sm, int timeout) throws SQLException {
        if (!rs.next()) {
            throw new LockException(sm.getManagedInstance(), timeout);
        }
    }
}

