/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUtil;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import javax.persistence.spi.ProviderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Persistence {
    protected static final Set<PersistenceProvider> providers = new HashSet<PersistenceProvider>();
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PeristenceProvider";
    static final String PERSISTENCE_PROVIDER_PROPERTY = "javax.persistence.provider";
    static final String PERSISTENCE_PROVIDER_SERVICE = "META-INF/services/" + PersistenceProvider.class.getName();

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName) {
        return Persistence.createEntityManagerFactory(persistenceUnitName, Collections.EMPTY_MAP);
    }

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        EntityManagerFactory factory = null;
        Map props = properties;
        if (props == null) {
            props = Collections.EMPTY_MAP;
        }
        PersistenceProviderResolver resolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
        List<PersistenceProvider> providers = resolver.getPersistenceProviders();
        Object propVal = props.get(PERSISTENCE_PROVIDER_PROPERTY);
        if (propVal != null && propVal instanceof String) {
            boolean isLoaded = false;
            String providerName = propVal.toString();
            for (PersistenceProvider provider : providers) {
                if (provider.getClass().getName().compareTo(providerName) != 0) continue;
                isLoaded = true;
                break;
            }
            if (!isLoaded && (factory = Persistence.createFactory(providerName.toString(), persistenceUnitName, props)) != null) {
                return factory;
            }
        }
        HashMap<String, Throwable> exceptions = new HashMap<String, Throwable>();
        StringBuffer foundProviders = null;
        for (PersistenceProvider provider : providers) {
            String providerName = provider.getClass().getName();
            try {
                factory = provider.createEntityManagerFactory(persistenceUnitName, props);
            }
            catch (Exception e) {
                exceptions.put(providerName, e);
            }
            if (factory != null) {
                return factory;
            }
            if (foundProviders == null) {
                foundProviders = new StringBuffer(providerName);
                continue;
            }
            foundProviders.append(", ");
            foundProviders.append(providerName);
        }
        if (foundProviders == null) {
            foundProviders = new StringBuffer("NONE");
        }
        if (exceptions.isEmpty()) {
            throw new PersistenceException("No persistence providers available for \"" + persistenceUnitName + "\" after trying the following discovered implementations: " + foundProviders);
        }
        throw Persistence.createPersistenceException("Explicit persistence provider error(s) occurred for \"" + persistenceUnitName + "\" after trying the following discovered implementations: " + foundProviders, exceptions);
    }

    private static EntityManagerFactory createFactory(String providerName, String persistenceUnitName, Map properties) throws PersistenceException {
        Class<?> providerClass;
        ClassLoader cl = PrivClassLoader.get(null);
        if (cl == null) {
            cl = PrivClassLoader.get(Persistence.class);
        }
        try {
            providerClass = Class.forName(providerName, true, cl);
        }
        catch (Exception e) {
            throw new PersistenceException("Invalid or inaccessible explicit provider class: " + providerName, e);
        }
        try {
            PersistenceProvider provider = (PersistenceProvider)providerClass.newInstance();
            return provider.createEntityManagerFactory(persistenceUnitName, properties);
        }
        catch (Exception e) {
            throw new PersistenceException("Explicit error returned from provider: " + providerName + " for PU: " + persistenceUnitName, e);
        }
    }

    private static PersistenceException createPersistenceException(String msg, Map<String, Throwable> failures) {
        String newline = System.getProperty("line.separator");
        StringWriter strWriter = new StringWriter();
        strWriter.append(msg);
        if (failures.size() <= 1) {
            Throwable t = null;
            Iterator<String> i$ = failures.keySet().iterator();
            if (i$.hasNext()) {
                String providerName = i$.next();
                t = failures.get(providerName);
                strWriter.append(" from provider: ");
                strWriter.append(providerName);
            }
            return new PersistenceException(strWriter.toString(), t);
        }
        strWriter.append(" with the following failures:");
        strWriter.append(newline);
        for (String providerName : failures.keySet()) {
            strWriter.append(providerName);
            strWriter.append(" returned: ");
            failures.get(providerName).printStackTrace(new PrintWriter(strWriter));
        }
        strWriter.append(newline);
        return new PersistenceException(strWriter.toString());
    }

    public static PersistenceUtil getPersistenceUtil() {
        return new PersistenceUtilImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrivClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> c;

        public static ClassLoader get(Class<?> c) {
            PrivClassLoader action = new PrivClassLoader(c);
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return action.run();
        }

        private PrivClassLoader(Class<?> c) {
            this.c = c;
        }

        @Override
        public ClassLoader run() {
            if (this.c != null) {
                return this.c.getClassLoader();
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private static class PersistenceUtilImpl
    implements PersistenceUtil {
        private PersistenceUtilImpl() {
        }

        public boolean isLoaded(Object entity, String attributeName) {
            LoadState ls;
            ProviderUtil pu;
            boolean isLoaded = true;
            PersistenceProviderResolver ppr = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
            List<PersistenceProvider> pps = ppr.getPersistenceProviders();
            for (PersistenceProvider pp : pps) {
                try {
                    pu = pp.getProviderUtil();
                    ls = pu.isLoadedWithoutReference(entity, attributeName);
                    if (ls == LoadState.LOADED) {
                        return true;
                    }
                    if (ls != LoadState.NOT_LOADED) continue;
                    return false;
                }
                catch (Throwable t) {
                }
            }
            for (PersistenceProvider pp : pps) {
                try {
                    pu = pp.getProviderUtil();
                    ls = pu.isLoadedWithReference(entity, attributeName);
                    if (ls == LoadState.LOADED) {
                        return true;
                    }
                    if (ls != LoadState.NOT_LOADED) continue;
                    return false;
                }
                catch (Throwable t) {
                }
            }
            return true;
        }

        public boolean isLoaded(Object entity) {
            PersistenceProviderResolver ppr = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
            List<PersistenceProvider> pps = ppr.getPersistenceProviders();
            for (PersistenceProvider pp : pps) {
                try {
                    ProviderUtil pu = pp.getProviderUtil();
                    LoadState ls = pu.isLoaded(entity);
                    if (ls == LoadState.LOADED) {
                        return true;
                    }
                    if (ls != LoadState.NOT_LOADED) continue;
                    return false;
                }
                catch (Throwable t) {
                }
            }
            return true;
        }
    }
}

