/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ManagedMBean;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.server.DiscoveryRegistry;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ServiceFinder;
import org.apache.openejb.server.ServiceLogger;
import org.apache.openejb.server.ServiceManager;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.finder.ResourceFinder;

public class SimpleServiceManager
extends ServiceManager {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER, SimpleServiceManager.class);
    private static ObjectName objectName = null;
    private ServerService[] daemons;
    private volatile boolean stopped = false;
    private final ServiceFinder serviceFinder;

    public SimpleServiceManager() {
        this(new SimpleServiceFinder("META-INF/"));
    }

    public SimpleServiceManager(ServiceFinder serviceFinder) {
        this.serviceFinder = serviceFinder;
    }

    private static ObjectName getDiscoveryRegistryObjectName() {
        if (null == objectName) {
            ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb");
            jmxName.set("type", "Server");
            jmxName.set("name", "DiscoveryRegistry");
            objectName = jmxName.build();
        }
        return objectName;
    }

    @Override
    public void init() throws Exception {
        try {
            ServiceLogger.MDCput("SERVER", "main");
            InetAddress localhost = InetAddress.getLocalHost();
            ServiceLogger.MDCput("HOST", localhost.getHostName());
        }
        catch (Throwable e) {
            // empty catch block
        }
        DiscoveryRegistry registry = new DiscoveryRegistry();
        try {
            LocalMBeanServer.get().registerMBean(new ManagedMBean((Object)registry), SimpleServiceManager.getDiscoveryRegistryObjectName());
        }
        catch (Throwable e) {
            logger.error("Failed to register 'openejb' MBean", e);
        }
        SystemInstance.get().setComponent(DiscoveryRegistry.class, (Object)registry);
        Map<String, Properties> availableServices = this.serviceFinder.mapAvailableServices(ServerService.class);
        List<ServerService> enabledServers = this.initServers(availableServices);
        this.daemons = enabledServers.toArray(new ServerService[enabledServers.size()]);
        this.stopped = false;
    }

    @Override
    public synchronized void start(boolean block) throws ServiceException {
        ServerService d;
        int i;
        if (this.stopped) {
            throw new ServiceException("Stop has already been called on ServiceManager");
        }
        boolean display = SystemInstance.get().getOptions().get("openejb.nobanner", (String)null) == null;
        Exception[] errors = new Exception[this.daemons.length];
        for (i = 0; i < this.daemons.length; ++i) {
            d = this.daemons[i];
            try {
                d.start();
                errors[i] = null;
                continue;
            }
            catch (Exception e) {
                errors[i] = e;
                LOGGER.info("Can't start service " + d.getName(), (Throwable)e);
            }
        }
        if (display) {
            LOGGER.info("  ** Bound Services **");
            this.printRow("NAME", "IP", "PORT");
        }
        for (i = 0; i < this.daemons.length; ++i) {
            d = this.daemons[i];
            if (errors[i] == null) {
                if (!display || d.getPort() == -1) continue;
                this.printRow(d.getName(), d.getIP(), d.getPort() + "");
                continue;
            }
            logger.fatal("Service Start Failed: " + d.getName() + " " + d.getIP() + " " + d.getPort() + ": " + errors[i].getMessage());
            if (!display) continue;
            this.printRow(d.getName(), "----", "FAILED");
        }
        if (display) {
            LOGGER.info("-------");
            LOGGER.info("Ready!");
        }
        if (!block) {
            return;
        }
        try {
            while (!this.stopped) {
                this.wait(Long.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            logger.fatal("Unable to keep the server thread alive. Received exception: " + t.getClass().getName() + " : " + t.getMessage());
        }
        logger.info("Stopping Remote Server");
    }

    @Override
    public synchronized void stop() throws ServiceException {
        logger.info("Stopping server services");
        this.stopped = true;
        ServerService[] services = (ServerService[])this.daemons.clone();
        MBeanServer server = LocalMBeanServer.get();
        for (ServerService service : services) {
            ObjectName on;
            if (LocalMBeanServer.isJMXActive() && server.isRegistered(on = SimpleServiceManager.getObjectName(service.getName()))) {
                try {
                    server.unregisterMBean(on);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            try {
                service.stop();
            }
            catch (ServiceException e) {
                logger.fatal("Service Shutdown Failed: " + service.getName() + ".  Exception: " + e.getMessage(), (Throwable)((Object)e));
            }
        }
        try {
            ObjectName objectName = SimpleServiceManager.getDiscoveryRegistryObjectName();
            if (server.isRegistered(objectName)) {
                server.unregisterMBean(objectName);
            }
        }
        catch (Throwable e) {
            logger.warning("Failed to de-register the 'openejb' mbean", e);
        }
        SimpleServiceManager.setServiceManager(null);
        this.notifyAll();
    }

    private void printRow(String col1, String col2, String col3) {
        col1 = col1 + "                    ";
        col1 = col1.substring(0, 20);
        col2 = col2 + "                    ";
        col2 = col2.substring(0, 15);
        col3 = col3 + "                    ";
        col3 = col3.substring(0, 6);
        String sb = "  " + col1 + " " + col2 + " " + col3;
        LOGGER.info(sb);
    }

    public ServerService[] getDaemons() {
        return this.daemons;
    }

    public static class SimpleServiceFinder
    implements ServiceFinder {
        private final ResourceFinder resourceFinder;
        private final ClassLoader classLoader;

        public SimpleServiceFinder(String basePath) {
            this(basePath, Thread.currentThread().getContextClassLoader());
        }

        public SimpleServiceFinder(String basePath, ClassLoader classLoader) {
            this.resourceFinder = new ResourceFinder(basePath, classLoader);
            this.classLoader = classLoader;
        }

        @Override
        public Map<String, Properties> mapAvailableServices(Class interfase) throws IOException, ClassNotFoundException {
            Map service = this.resourceFinder.mapAvailableProperties(ServerService.class.getName());
            for (Map.Entry entry : service.entrySet()) {
                String name = (String)entry.getKey();
                Properties properties = (Properties)entry.getValue();
                String className = properties.getProperty("className");
                if (className == null && (className = properties.getProperty("classname")) == null) {
                    className = properties.getProperty("server");
                }
                Class<?> impl = this.classLoader.loadClass(className);
                properties.put(interfase, impl);
                String rawProperties = this.resourceFinder.findString(interfase.getName() + "/" + name);
                properties.put(Properties.class, rawProperties);
            }
            return service;
        }
    }
}

