/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.Managed;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServerServiceFilter;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

@Managed
public class ServicePool
extends ServerServiceFilter {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.SERVICEPOOL, (String)"org.apache.openejb.util.resources");
    private static final int KEEP_ALIVE_TIME = 60000;
    private final ThreadPoolExecutor threadPool;
    private final AtomicBoolean stop = new AtomicBoolean();
    @Managed
    private final Pool pool = new Pool();

    public ServicePool(ServerService next, Properties properties) {
        this(next, new Options(properties).get("threadsCore", 10), new Options(properties).get("threads", 150), new Options(properties).get("queue", 0), new Options(properties).get("block", true), new Options(properties).get("keepAliveTime", 60000));
    }

    public ServicePool(ServerService next, int threads) {
        this(next, threads, threads, 0, true, 60000L);
    }

    public ServicePool(ServerService next, int threads, int queue, boolean block) {
        this(next, threads, threads, queue, block, 60000L);
    }

    public ServicePool(ServerService next, int threadCore, int threads, int queue, final boolean block, long keepAliveTime) {
        super(next);
        if (keepAliveTime <= 0L) {
            keepAliveTime = 60000L;
        }
        if (threadCore <= 2) {
            threadCore = 2;
        }
        if (threads < threadCore) {
            threads = threadCore;
        }
        if (queue >= threadCore || queue < 1) {
            queue = threadCore - 1;
        }
        final int c = threadCore;
        final int t = threads;
        final int q = queue;
        this.threadPool = new ThreadPoolExecutor(threadCore, threads, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queue), new ThreadFactory(){
            private final AtomicInteger i = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "OpenEJB." + ServicePool.this.getName() + "." + this.i.incrementAndGet());
                t.setDaemon(true);
                t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        log.error("ServicePool '" + ServicePool.this.getName() + "': Uncaught error in: " + t.getName(), e);
                    }
                });
                return t;
            }
        }, new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor tpe) {
                if (null == r || null == tpe || tpe.isShutdown() || tpe.isTerminated() || tpe.isTerminating()) {
                    return;
                }
                if (log.isWarningEnabled()) {
                    log.warning(String.format("ServicePool '" + ServicePool.this.getName() + "' with (%1$s) threads is at capicity (%2$s) for queue (%3$s) on process: %4$s" + "\nConsider increasing the 'threadCore','threads' and 'queue' size properties.", c, t, q, r));
                }
                boolean offer = false;
                try {
                    offer = tpe.getQueue().offer(r, 10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!offer) {
                    if (block) {
                        try {
                            r.run();
                            log.warning("ServicePool '" + ServicePool.this.getName() + "' forced execution on the current server thread: " + r + "\nIt is highly recommended that the service 'threadCore','threads' and 'queue' size properties are increased!");
                        }
                        catch (Throwable e) {
                            log.error("ServicePool '" + ServicePool.this.getName() + "' failed to run a process in the current server thread: " + r);
                        }
                    } else {
                        log.error("ServicePool '" + ServicePool.this.getName() + "' rejected asynchronous process: " + r + "\nIt is strongly advised that the 'threadCore', 'threads', 'queue' size and 'block' properties are modified to prevent data loss!");
                    }
                }
            }
        });
        SystemInstance.get().setComponent(ServicePool.class, (Object)this);
        if (log.isInfoEnabled()) {
            log.info(String.format("Created ServicePool '%1$s' with (%2$s) core threads, limited to (%3$s) threads with a queue of (%4$s)", this.getName(), c, t, q));
        }
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    @Override
    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    @Override
    public void service(final Socket socket) throws ServiceException, IOException {
        final ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Runnable ctxCL = new Runnable(){

            public String toString() {
                return "ServicePool." + ServicePool.this.getName() + ".Socket:" + socket.getInetAddress();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(tccl);
                    if (ServicePool.this.stop.get()) {
                        return;
                    }
                    ServicePool.super.service(socket);
                }
                catch (SecurityException e) {
                    String msg = "ServicePool '" + ServicePool.this.getName() + "': Security error: " + e.getMessage();
                    if (log.isDebugEnabled()) {
                        log.error(msg, (Throwable)e);
                    } else {
                        log.error(msg + " - Debug for StackTrace");
                    }
                }
                catch (IOException e) {
                    String msg = "ServicePool '" + ServicePool.this.getName() + "': Unexpected IO error: " + e.getMessage();
                    if (log.isDebugEnabled()) {
                        log.debug(msg, (Throwable)e);
                    } else {
                        log.warning(msg + " - Debug for StackTrace");
                    }
                }
                catch (Throwable e) {
                    String msg = "ServicePool '" + ServicePool.this.getName() + "': Unexpected error: " + e.getMessage();
                    if (log.isDebugEnabled()) {
                        log.error(msg, e);
                    } else {
                        log.error(msg + " - Debug for StackTrace");
                    }
                }
                finally {
                    block31: {
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (Throwable t) {
                            if (!log.isDebugEnabled()) break block31;
                            log.debug("ServicePool '" + ServicePool.this.getName() + "': Error closing socket", t);
                        }
                    }
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
        };
        this.threadPool.execute(ctxCL);
    }

    @Managed(append=true)
    public class Pool {
        @Managed
        public boolean isShutdown() {
            return ServicePool.this.getThreadPool().isShutdown();
        }

        @Managed
        public boolean isTerminating() {
            return ServicePool.this.getThreadPool().isTerminating();
        }

        @Managed
        public boolean isTerminated() {
            return ServicePool.this.getThreadPool().isTerminated();
        }

        @Managed
        public int getPoolSize() {
            return ServicePool.this.getThreadPool().getPoolSize();
        }

        @Managed
        public int getCorePoolSize() {
            return ServicePool.this.getThreadPool().getCorePoolSize();
        }

        @Managed
        public int getMaximumPoolSize() {
            return ServicePool.this.getThreadPool().getMaximumPoolSize();
        }

        @Managed
        public long getKeepAliveTime(TimeUnit unit) {
            return ServicePool.this.getThreadPool().getKeepAliveTime(unit);
        }

        @Managed
        public int getQueueSize() {
            return ServicePool.this.getThreadPool().getQueue().size();
        }

        @Managed
        public int getActiveCount() {
            return ServicePool.this.getThreadPool().getActiveCount();
        }

        @Managed
        public int getLargestPoolSize() {
            return ServicePool.this.getThreadPool().getLargestPoolSize();
        }

        @Managed
        public long getTaskCount() {
            return ServicePool.this.getThreadPool().getTaskCount();
        }

        @Managed
        public long getCompletedTaskCount() {
            return ServicePool.this.getThreadPool().getCompletedTaskCount();
        }

        @Managed
        public void setMaximumPoolSize(int maximumPoolSize) {
            ServicePool.this.getThreadPool().setMaximumPoolSize(maximumPoolSize);
            if (log.isInfoEnabled()) {
                log.info(String.format("Set ServicePool '" + ServicePool.this.getName() + "' maximum threads to (%1$s)", maximumPoolSize));
            }
        }

        @Managed
        public void setCorePoolSize(int corePoolSize) {
            ServicePool.this.getThreadPool().setCorePoolSize(corePoolSize);
            if (log.isInfoEnabled()) {
                log.info(String.format("Set ServicePool '" + ServicePool.this.getName() + "' core threads to (%1$s)", corePoolSize));
            }
        }

        @Managed
        public void allowCoreThreadTimeOut(boolean value) {
            ServicePool.this.getThreadPool().allowCoreThreadTimeOut(value);
            if (log.isInfoEnabled()) {
                log.info(String.format("Set ServicePool '" + ServicePool.this.getName() + "' allow core thread timeout to (%1$s)", value));
            }
        }

        @Managed(description="Sets time in nanoseconds")
        public void setKeepAliveTime(long time) {
            ServicePool.this.getThreadPool().setKeepAliveTime(time, TimeUnit.NANOSECONDS);
            if (log.isInfoEnabled()) {
                log.info(String.format("Set ServicePool '" + ServicePool.this.getName() + "' keep alive time to (%1$s) nanoseconds", time));
            }
        }
    }
}

