/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.openejb.EnvProps;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ManagedMBean;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.DiscoveryRegistry;
import org.apache.openejb.server.NamedService;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceAccessController;
import org.apache.openejb.server.ServiceDaemon;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ServiceLogger;
import org.apache.openejb.server.ServicePool;
import org.apache.openejb.server.ServiceStats;
import org.apache.openejb.server.SimpleServiceManager;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.PropertyPlaceHolderHelper;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.ReflectionUtil;

public abstract class ServiceManager {
    static Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER, (String)"org.apache.openejb.server.util.resources");
    private static ServiceManager manager;

    public static ServiceManager getManager() {
        if (manager == null) {
            manager = new SimpleServiceManager();
        }
        return manager;
    }

    public static ServiceManager get() {
        return manager;
    }

    protected static void setServiceManager(ServiceManager newManager) {
        manager = newManager;
    }

    protected boolean accept(String serviceName) {
        return true;
    }

    protected List<ServerService> initServers(Map<String, Properties> availableServices) throws IOException {
        ArrayList<ServerService> enabledServers = new ArrayList<ServerService>();
        for (Map.Entry<String, Properties> serviceInfo : availableServices.entrySet()) {
            ServerService service;
            String serviceName = serviceInfo.getKey();
            if (!this.accept(serviceName) || (service = this.initServer(serviceName, serviceInfo.getValue())) == null) continue;
            enabledServers.add(service);
        }
        return enabledServers;
    }

    protected ServerService initServer(String serviceName, Properties serviceProperties) throws IOException {
        DiscoveryRegistry registry = (DiscoveryRegistry)SystemInstance.get().getComponent(DiscoveryRegistry.class);
        OpenEjbConfiguration conf = (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
        logger.debug("Processing ServerService(id=" + serviceName + ")");
        this.overrideProperties(serviceName, serviceProperties);
        serviceProperties.setProperty("name", serviceName);
        if (conf != null && conf.facilities != null) {
            ServiceInfo info = new ServiceInfo();
            info.className = ((Class)serviceProperties.get(ServerService.class)).getName();
            info.service = "ServerService";
            info.id = serviceName;
            info.properties = serviceProperties;
            conf.facilities.services.add(info);
        }
        boolean enabled = ServiceManager.isEnabled(serviceProperties);
        logger.debug("Found ServerService(id=" + serviceName + ", disabled=" + !enabled + ")");
        if (enabled) {
            Class serviceClass = (Class)serviceProperties.get(ServerService.class);
            logger.info("Creating ServerService(id=" + serviceName + ")");
            if (logger.isDebugEnabled()) {
                for (Map.Entry<Object, Object> entry : serviceProperties.entrySet()) {
                    logger.debug(entry.getKey() + " = " + entry.getValue());
                }
            }
            try {
                ObjectRecipe recipe = new ObjectRecipe(serviceClass);
                try {
                    if (ReflectionUtil.findStaticFactory((Class)serviceClass, (String)"createServerService", null, null) != null) {
                        recipe = new ObjectRecipe(serviceClass, "createServerService");
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
                recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
                ServerService service = (ServerService)recipe.create(serviceClass.getClassLoader());
                if (!(service instanceof SelfManaging)) {
                    service = ServiceManager.manage(serviceName, serviceProperties, service);
                }
                service.init(serviceProperties);
                if (service instanceof DiscoveryAgent) {
                    DiscoveryAgent agent = (DiscoveryAgent)((Object)service);
                    registry.addDiscoveryAgent(agent);
                }
                if (LocalMBeanServer.isJMXActive()) {
                    MBeanServer server = LocalMBeanServer.get();
                    ServiceManager.register(serviceName, service, server);
                }
                return service;
            }
            catch (Throwable t) {
                t.printStackTrace();
                logger.error("service.instantiation.err", t, new Object[]{serviceClass.getName(), t.getClass().getName(), t.getMessage()});
            }
        }
        return null;
    }

    protected static ObjectName getObjectName(String serviceName) {
        ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb");
        jmxName.set("type", "ServerService");
        jmxName.set("name", serviceName);
        return jmxName.build();
    }

    public static void register(String serviceName, ServerService service, MBeanServer server) {
        try {
            ObjectName on = ServiceManager.getObjectName(serviceName);
            if (server.isRegistered(on)) {
                server.unregisterMBean(on);
            }
            server.registerMBean(new ManagedMBean((Object)service), on);
        }
        catch (Exception e) {
            logger.error("Unable to register MBean ", (Throwable)e);
        }
    }

    public static ServerService manage(String serviceName, Properties serviceProperties, ServerService service) {
        service = new NamedService(service, serviceName);
        service = new ServiceStats(service);
        service = new ServiceLogger(service);
        service = new ServicePool(service, serviceProperties);
        service = new ServiceAccessController(service);
        service = new ServiceDaemon(service);
        return service;
    }

    private void overrideProperties(String serviceName, Properties serviceProperties) throws IOException {
        SystemInstance systemInstance = SystemInstance.get();
        FileUtils base = systemInstance.getBase();
        File conf = base.getDirectory("conf");
        if (conf.exists()) {
            File[] files;
            String legacy = System.getProperty("openejb.conf.schema.legacy");
            boolean legacySchema = Boolean.parseBoolean(null != legacy ? legacy : "false");
            if (null == legacy && null != (files = conf.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return (name = name.toLowerCase()).equals("ejbd.properties") || name.equals("ejbds.properties") || name.equals("admin.properties") || name.equals("httpejbd.properties");
                }
            })) && files.length > 1) {
                legacySchema = true;
            }
            this.addProperties(conf, legacySchema, new File(conf, serviceName + ".properties"), serviceProperties, true);
            this.addProperties(conf, legacySchema, new File(conf, SystemInstance.get().currentProfile() + "." + serviceName + ".properties"), serviceProperties, false);
        }
        PropertyPlaceHolderHelper.holdsWithUpdate((Properties)serviceProperties);
        String prefix = serviceName + ".";
        Properties sysProps = new Properties(System.getProperties());
        sysProps.putAll((Map<?, ?>)systemInstance.getProperties());
        Iterator<Map.Entry<Object, Object>> i$ = sysProps.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<Object, Object> entry;
            Map.Entry<Object, Object> entry1 = entry = i$.next();
            Object value = entry1.getValue();
            String key = (String)entry1.getKey();
            if (!(value instanceof String) || !key.startsWith(prefix)) continue;
            key = key.replaceFirst(prefix, "");
            serviceProperties.setProperty(key, (String)value);
        }
    }

    private void addProperties(File conf, boolean legacySchema, File path, Properties fullProps, boolean tryToDump) throws IOException {
        File serviceConfig = path;
        if (!serviceConfig.exists()) {
            serviceConfig = new File(conf, (legacySchema ? "" : "conf.d/") + serviceConfig.getName());
            if (legacySchema) {
                logger.info("Using legacy configuration path for new service: " + serviceConfig);
            }
        }
        Properties props = new Properties();
        if (serviceConfig.exists()) {
            IO.readProperties((File)serviceConfig, (Properties)props);
        } else if (tryToDump) {
            File confD = serviceConfig.getParentFile();
            if (!confD.exists() && !confD.mkdirs()) {
                logger.warning("Failed to create " + serviceConfig.getPath());
            }
            if (confD.exists()) {
                if (EnvProps.extractConfigurationFiles()) {
                    String rawPropsContent = (String)fullProps.get(Properties.class);
                    if (rawPropsContent != null) {
                        IO.copy((InputStream)IO.read((String)rawPropsContent), (File)serviceConfig);
                    }
                } else {
                    props.put("disabled", "true");
                }
            }
        }
        fullProps.putAll((Map<?, ?>)props);
    }

    public static boolean isEnabled(Properties props) {
        String disabled = props.getProperty("disabled", "");
        return !disabled.equalsIgnoreCase("yes") && !disabled.equalsIgnoreCase("true");
    }

    public abstract void init() throws Exception;

    public void start() throws ServiceException {
        this.start(true);
    }

    public abstract void start(boolean var1) throws ServiceException;

    public abstract void stop() throws ServiceException;
}

