/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.openejb.EnvProps;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ManagedMBean;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.DiscoveryRegistry;
import org.apache.openejb.server.NamedService;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceAccessController;
import org.apache.openejb.server.ServiceDaemon;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ServiceLogger;
import org.apache.openejb.server.ServicePool;
import org.apache.openejb.server.ServiceStats;
import org.apache.openejb.server.SimpleServiceManager;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.ReflectionUtil;

public abstract class ServiceManager {
    static Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER, (String)"org.apache.openejb.server.util.resources");
    private static ServiceManager manager;

    public static ServiceManager getManager() {
        if (manager == null) {
            manager = new SimpleServiceManager();
        }
        return manager;
    }

    public static ServiceManager get() {
        return manager;
    }

    protected static void setServiceManager(ServiceManager newManager) {
        manager = newManager;
    }

    protected boolean accept(String serviceName) {
        return true;
    }

    protected List<ServerService> initServers(Map<String, Properties> availableServices) throws IOException {
        ArrayList<ServerService> enabledServers = new ArrayList<ServerService>();
        for (Map.Entry<String, Properties> serviceInfo : availableServices.entrySet()) {
            ServerService service;
            String serviceName = serviceInfo.getKey();
            if (!this.accept(serviceName) || (service = this.initServer(serviceName, serviceInfo.getValue())) == null) continue;
            enabledServers.add(service);
        }
        return enabledServers;
    }

    protected ServerService initServer(String serviceName, Properties serviceProperties) throws IOException {
        DiscoveryRegistry registry = (DiscoveryRegistry)SystemInstance.get().getComponent(DiscoveryRegistry.class);
        OpenEjbConfiguration conf = (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
        logger.debug("Processing ServerService(id=" + serviceName + ")");
        this.overrideProperties(serviceName, serviceProperties);
        serviceProperties.setProperty("name", serviceName);
        if (conf != null && conf.facilities != null) {
            ServiceInfo info = new ServiceInfo();
            info.className = ((Class)serviceProperties.get(ServerService.class)).getName();
            info.service = "ServerService";
            info.id = serviceName;
            info.properties = serviceProperties;
            conf.facilities.services.add(info);
        }
        boolean enabled = this.isEnabled(serviceProperties);
        logger.debug("Found ServerService(id=" + serviceName + ", disabled=" + !enabled + ")");
        if (enabled) {
            Class serviceClass = (Class)serviceProperties.get(ServerService.class);
            logger.info("Creating ServerService(id=" + serviceName + ")");
            if (logger.isDebugEnabled()) {
                for (Map.Entry<Object, Object> entry : serviceProperties.entrySet()) {
                    logger.debug(entry.getKey() + " = " + entry.getValue());
                }
            }
            try {
                ObjectRecipe recipe = new ObjectRecipe(serviceClass);
                try {
                    if (ReflectionUtil.findStaticFactory((Class)serviceClass, (String)"createServerService", null, null) != null) {
                        recipe = new ObjectRecipe(serviceClass, "createServerService");
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
                recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
                ServerService service = (ServerService)recipe.create(serviceClass.getClassLoader());
                if (!(service instanceof SelfManaging)) {
                    service = ServiceManager.manage(serviceName, serviceProperties, service);
                }
                service.init(serviceProperties);
                if (service instanceof DiscoveryAgent) {
                    DiscoveryAgent agent = (DiscoveryAgent)((Object)service);
                    registry.addDiscoveryAgent(agent);
                }
                MBeanServer server = LocalMBeanServer.get();
                ServiceManager.register(serviceName, service, server);
                return service;
            }
            catch (Throwable t) {
                logger.error("service.instantiation.err", t, new Object[]{serviceClass.getName(), t.getClass().getName(), t.getMessage()});
            }
        }
        return null;
    }

    public static void register(String serviceName, ServerService service, MBeanServer server) {
        ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb");
        jmxName.set("type", "ServerService");
        jmxName.set("name", serviceName);
        try {
            ObjectName objectName = jmxName.build();
            server.registerMBean(new ManagedMBean((Object)service), objectName);
        }
        catch (Exception e) {
            logger.error("Unable to register MBean ", (Throwable)e);
        }
    }

    public static ServerService manage(String serviceName, Properties serviceProperties, ServerService service) {
        service = new NamedService(service, serviceName);
        service = new ServiceStats(service);
        service = new ServiceLogger(service);
        service = new ServicePool(service, serviceProperties);
        service = new ServiceAccessController(service);
        service = new ServiceDaemon(service);
        return service;
    }

    private void overrideProperties(String serviceName, Properties serviceProperties) throws IOException {
        FileUtils base = SystemInstance.get().getBase();
        File conf = base.getDirectory("conf");
        if (conf.exists()) {
            File serviceConfig = new File(conf, serviceName + ".properties");
            if (!serviceConfig.exists()) {
                serviceConfig = new File(conf, "conf.d/" + serviceConfig.getName());
            }
            if (serviceConfig.exists()) {
                IO.readProperties((File)serviceConfig, (Properties)serviceProperties);
            } else {
                File confD = serviceConfig.getParentFile();
                if (!confD.exists() && !confD.mkdirs()) {
                    logger.warning("can't create " + serviceConfig.getPath());
                }
                if (confD.exists()) {
                    if (EnvProps.extractConfigurationFiles()) {
                        String rawPropsContent = (String)serviceProperties.get(Properties.class);
                        IO.copy((InputStream)IO.read((String)rawPropsContent), (File)serviceConfig);
                    } else {
                        serviceProperties.put("disabled", "true");
                    }
                }
            }
        }
        String prefix = serviceName + ".";
        Properties sysProps = new Properties(System.getProperties());
        sysProps.putAll((Map<?, ?>)SystemInstance.get().getProperties());
        for (Map.Entry<Object, Object> entry1 : sysProps.entrySet()) {
            Object value = entry1.getValue();
            String key = (String)entry1.getKey();
            if (!(value instanceof String) || !key.startsWith(prefix)) continue;
            key = key.replaceFirst(prefix, "");
            serviceProperties.setProperty(key, (String)value);
        }
    }

    private boolean isEnabled(Properties props) {
        String disabled = props.getProperty("disabled", "");
        return !disabled.equalsIgnoreCase("yes") && !disabled.equalsIgnoreCase("true");
    }

    public abstract void init() throws Exception;

    public void start() throws ServiceException {
        this.start(true);
    }

    public abstract void start(boolean var1) throws ServiceException;

    public abstract void stop() throws ServiceException;
}

