/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.Server;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class AdminDaemon
implements ServerService {
    public void init(Properties props) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(Socket socket) throws ServiceException, IOException {
        InputStream in = null;
        try {
            in = socket.getInputStream();
            byte requestType = (byte)in.read();
            switch (requestType) {
                case -1: {
                    return;
                }
                case 81: 
                case 83: 
                case 113: 
                case 115: {
                    Server server = (Server)SystemInstance.get().getComponent(Server.class);
                    server.stop();
                    return;
                }
                default: {
                    Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER, AdminDaemon.class).warning("Invalid Server Socket request: " + requestType);
                    return;
                }
            }
        }
        catch (Throwable e) {
            Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER, AdminDaemon.class).warning("Server Socket request failed", e);
            return;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (Throwable t) {}
            }
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException("Method not implemented: service(InputStream in, OutputStream out)");
    }

    public void start() throws ServiceException {
    }

    public void stop() throws ServiceException {
    }

    public int getPort() {
        return 0;
    }

    public String getIP() {
        return "";
    }

    public String getName() {
        return "admin thread";
    }
}

