/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.openejb.client.AbstractConnectionStrategy;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.event.FailoverSelection;
import org.apache.openejb.client.event.RoundRobinFailoverSelection;

public class RoundRobinConnectionStrategy
extends AbstractConnectionStrategy {
    @Override
    protected FailoverSelection createFailureEvent(Set<URI> remaining, Set<URI> failed, URI uri) {
        return new RoundRobinFailoverSelection(remaining, failed, uri);
    }

    @Override
    protected Iterable<URI> createIterable(ClusterMetaData cluster) {
        return new RoundRobinIterable(cluster);
    }

    private static class RoundRobinIterable
    implements Iterable<URI> {
        private final URI[] locations;
        private AtomicInteger index = new AtomicInteger(-1);

        private RoundRobinIterable(ClusterMetaData clusterMetaData) {
            this.locations = clusterMetaData.getLocations();
        }

        private int index() {
            int i = this.index.incrementAndGet();
            if (i < this.locations.length) {
                return i;
            }
            this.index.compareAndSet(i, -1);
            return this.index();
        }

        @Override
        public Iterator<URI> iterator() {
            return new RoundRobinIterator();
        }

        private class RoundRobinIterator
        implements Iterator<URI> {
            private final Set<URI> seen = new HashSet<URI>();

            private RoundRobinIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.seen.size() < RoundRobinIterable.this.locations.length;
            }

            @Override
            public URI next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                URI location = RoundRobinIterable.this.locations[RoundRobinIterable.this.index()];
                this.seen.add(location);
                return location;
            }

            @Override
            public void remove() {
            }
        }
    }
}

